/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.cable_blocks;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CableHubBlockEntity
extends ElectricBlockEntity {
    int signal;
    boolean signalChanged;
    byte[] directions = new byte[6];

    public CableHubBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.neighbourChanged();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    @Override
    public void tick() {
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
        super.tick();
    }

    public void neighbourChanged() {
        if (!this.m_58898_()) {
            return;
        }
        ArrayList list = new ArrayList();
        int power = this.f_58857_.m_277086_(this.f_58858_);
        if (power != this.signal) {
            this.signalChanged = true;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    protected void analogSignalChanged(int newSignal) {
        this.signal = newSignal;
    }

    @Override
    public boolean hasSignal() {
        return this.signal > 0;
    }

    @Override
    public float maxVoltage() {
        return 6000.0f;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Signal", this.signal);
        compound.m_128382_("Directions", this.directions);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.signal = compound.m_128451_("Signal");
        this.directions = compound.m_128463_("Directions");
        super.read(compound, clientPacket);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }
}

