/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.capacitor;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CapacitorBlockEntity
extends ElectricBlockEntity {
    public int lastVoltage = 0;

    public CapacitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public float maxVoltage() {
        return 1000.0f;
    }

    @Override
    public void manageVoltage() {
        if (this.voltageGeneration() > 0) {
            this.voltage = this.voltageGeneration();
            this.distanceFromSource = 0;
        }
        this.current = this.energy.getEnergyStored() / (this.voltage + 1);
        if (this.voltage == 0) {
            this.setDistanceFromSource(Integer.MAX_VALUE);
        }
        if ((float)this.voltage > this.maxVoltage()) {
            this.explode();
            this.voltage = 0;
        }
    }

    @Override
    public int voltageGeneration() {
        if (this.energy.getEnergyStored() == 0) {
            this.voltage = 0;
            return 0;
        }
        return this.voltage;
    }

    @Override
    public int FECapacity() {
        return 30000;
    }

    @Override
    public int transferSpeed() {
        return 1000;
    }

    @Override
    public boolean isStorage() {
        return true;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction.m_122434_().m_122478_();
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("LastVoltage", this.lastVoltage);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.lastVoltage = compound.m_128451_("LastVoltage");
    }
}

