/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.electric_motor;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.IElectricBlock;
import com.drmangotea.tfmg.blocks.electricity.base.TFMGForgeEnergyStorage;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ElectricMotorBlockEntity
extends GeneratingKineticBlockEntity
implements IElectricBlock,
IHaveGoggleInformation {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    public int voltage;
    private int voltageLastTick;
    public int current;
    private int energyUsed;
    private boolean gotFElastTick;
    public int distanceFromSource;
    protected ScrollValueBehaviour generatedSpeed;
    private LazyOptional<IEnergyStorage> lazyEnergyHandler;
    public final TFMGForgeEnergyStorage energy;

    public ElectricMotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.voltageLastTick = this.voltage = 0;
        this.current = 0;
        this.energyUsed = 0;
        this.gotFElastTick = false;
        this.distanceFromSource = Integer.MAX_VALUE;
        this.lazyEnergyHandler = LazyOptional.empty();
        this.energy = this.createEnergyStorage();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)Lang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!TFMGBlocks.ELECTRIC_MOTOR.has(this.m_58900_())) {
            return 0.0f;
        }
        if ((double)this.energy.getEnergyStored() < (double)this.energy.getMaxEnergyStored() * 0.25) {
            return 0.0f;
        }
        this.energyUsed = this.energy.extractEnergy((int)Math.abs((double)this.speed * 1.7), false);
        if (this.energy.getEnergyStored() == 0) {
            return 0.0f;
        }
        return ElectricMotorBlockEntity.convertToDirection((float)Math.min(this.generatedSpeed.getValue(), this.voltage * 2), (Direction)((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)));
    }

    public void tick() {
        super.tick();
        this.manageVoltage();
        this.sendCharge(this.f_58857_, this.m_58899_());
        if (this.energy.getEnergyStored() > 0) {
            this.updateGeneratedRotation();
        } else {
            this.sendData();
        }
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_();
    }

    public TFMGForgeEnergyStorage getEnergy() {
        return this.energy;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energy);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == null) {
            return this.lazyEnergyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.hasElectricitySlot(side)) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void manageVoltage() {
        if (this.voltageLastTick != this.voltage) {
            this.updateGeneratedRotation();
        }
        if (this.voltageGeneration() > 0) {
            this.voltage = this.voltageGeneration();
            this.distanceFromSource = 0;
        }
        if (this.distanceFromSource == Integer.MAX_VALUE) {
            this.voltage = 0;
        }
        this.current = this.energy.getEnergyStored() / (this.voltage + 1);
        if ((float)this.voltage > this.maxVoltage()) {
            this.explode();
            this.voltage = 0;
        }
        this.voltageLastTick = this.voltage;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    @Override
    public float internalResistance() {
        return 0.0f;
    }

    @Override
    public int getVoltage() {
        return this.voltage;
    }

    @Override
    public boolean gotFElastTick(int value) {
        this.gotFElastTick = value == 3 ? this.gotFElastTick : value == 1;
        return this.gotFElastTick;
    }

    @Override
    public int getCurrent() {
        return this.current;
    }

    @Override
    public void addVoltage(float amount) {
        if (this.voltageGeneration() > 0) {
            return;
        }
        this.voltage = (int)amount;
    }

    @Override
    public TFMGForgeEnergyStorage getForgeEnergy() {
        return this.energy;
    }

    @Override
    public float maxVoltage() {
        return 1000.0f;
    }

    @Override
    public void explode() {
        TFMGUtils.createFireExplosion(this.f_58857_, null, this.m_58899_(), 10, 1.5f);
    }

    @Override
    public int FECapacity() {
        return 5000;
    }

    @Override
    public int getDistanceFromSource() {
        return this.distanceFromSource;
    }

    @Override
    public void setDistanceFromSource(int value) {
        this.distanceFromSource = value;
        this.sendStuff();
    }

    @Override
    public void sendStuff() {
        this.sendData();
        this.m_6596_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeElectrity(compound);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.voltage = compound.m_128451_("Voltage");
        this.current = compound.m_128451_("Current");
        this.distanceFromSource = compound.m_128451_("DistanceFromSource");
        this.energy.setEnergy(compound.m_128451_("ForgeEnergy"));
    }

    @Override
    public int feGeneration() {
        return 0;
    }

    @Override
    public int voltageGeneration() {
        return 0;
    }

    @Override
    public int transferSpeed() {
        return 1000;
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            return super.getLocalOffset(state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN || direction == Direction.UP) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

