/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.creative_generator;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.IElectricBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CreativeGeneratorBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    protected ScrollValueBehaviour outputVoltage;

    public CreativeGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        this.energy.setEnergy(5000);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.outputVoltage = new ScrollValueBehaviour((Component)Lang.translateDirect((String)"creative_generator.voltage_generation", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new CreativeGeneratorValueBox());
        this.outputVoltage.between(0, max);
        this.outputVoltage.value = 50;
        behaviours.add((BlockEntityBehaviour)this.outputVoltage);
    }

    @Override
    public float maxVoltage() {
        return Float.MAX_VALUE;
    }

    @Override
    public int feGeneration() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int voltageGeneration() {
        return this.outputVoltage.getValue() * 10;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    @Override
    public int transferSpeed() {
        return 1000;
    }

    @Override
    public void transferCharge(IElectricBlock be) {
        int energy = this.getForgeEnergy().getEnergyStored();
        int freeSpace = be.getForgeEnergy().getMaxEnergyStored() - be.getForgeEnergy().getEnergyStored();
        int maxPossibleTransfer = 1000;
        int test = be.getForgeEnergy().receiveEnergy(maxPossibleTransfer, true);
        int test2 = this.getForgeEnergy().extractEnergy(maxPossibleTransfer, true);
        maxPossibleTransfer = Math.min(Math.min(test2, test2), maxPossibleTransfer);
        if (be.getForgeEnergy().getEnergyStored() <= this.getForgeEnergy().getEnergyStored()) {
            be.getForgeEnergy().receiveEnergy(Integer.MAX_VALUE, false);
        }
    }

    class CreativeGeneratorValueBox
    extends ValueBoxTransform.Sided {
        CreativeGeneratorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public Vec3 getLocalOffset(BlockState state) {
            return super.getLocalOffset(state);
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }
    }
}

