/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.generator;

import com.drmangotea.tfmg.blocks.electricity.base.KineticElectricBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GeneratorBlockEntity
extends KineticElectricBlockEntity {
    LerpedFloat generationSpeed = LerpedFloat.linear();

    public GeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        float targetSpeed = this.getSpeed();
        this.generationSpeed.updateChaseTarget(targetSpeed);
        this.generationSpeed.tickChaser();
    }

    @Override
    public int feGeneration() {
        return (int)Math.abs((double)this.getSpeed() * 1.5);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_();
    }

    @Override
    public int voltageGeneration() {
        return (int)Math.abs(this.getSpeed());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.generationSpeed.chase((double)this.getGeneratedSpeed(), 0.0625, LerpedFloat.Chaser.EXP);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        Lang.translate((String)"goggles.generator.production", (Object[])new Object[]{this.voltageGeneration()}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }
}

