/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.large_generator;

import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlock;
import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RotorBlockEntity
extends KineticBlockEntity {
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;
    List<BlockPos> statorBlocks = new ArrayList<BlockPos>();
    public boolean valid = false;

    public RotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.0078125, LerpedFloat.Chaser.EXP);
    }

    public void tick() {
        super.tick();
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
        if (this.valid) {
            this.generateVoltage();
        }
        for (BlockPos pos : this.statorBlocks) {
            if (this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.STATOR.get())) continue;
            this.statorBlocks = new ArrayList<BlockPos>();
        }
        if (this.statorBlocks.toArray().length == 8) {
            this.valid = true;
            this.valid = true;
        } else {
            this.valid = false;
            this.manageStator();
        }
    }

    public void generateVoltage() {
        float power = 2.5f * this.getSpeed() * (this.getSpeed() / 25.0f);
        for (BlockPos pos : this.statorBlocks) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof StatorBlockEntity)) continue;
            StatorBlockEntity be = (StatorBlockEntity)blockEntity;
            if (!be.hasOutput) continue;
            be.generation = power;
        }
    }

    public void manageStator() {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        this.statorBlocks = new ArrayList<BlockPos>();
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == axis) continue;
            BlockPos pos1 = this.m_58899_().m_121945_(direction);
            if (this.canUseStator(pos1)) {
                if (axis == Direction.Axis.Z && direction.m_122434_().m_122478_()) {
                    this.f_58857_.m_7731_(pos1, (BlockState)((BlockState)((BlockState)TFMGBlocks.STATOR.getDefaultState().m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)direction.m_122424_())).m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.SIDE))).m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(true)), 2);
                    this.statorBlocks.add(pos1);
                } else {
                    this.f_58857_.m_7731_(pos1, (BlockState)((BlockState)((BlockState)TFMGBlocks.STATOR.getDefaultState().m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)direction.m_122424_())).m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.SIDE))).m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false)), 2);
                    this.statorBlocks.add(pos1);
                }
                ((StatorBlockEntity)this.f_58857_.m_7702_(pos1)).setRotor(this);
            }
            if (!direction.m_122434_().m_122478_()) continue;
            for (Direction direction2 : Direction.values()) {
                BlockPos pos;
                if (direction2.m_122434_() == axis || direction2.m_122434_() == direction.m_122434_() || !this.canUseStator(pos = pos1.m_121945_(direction2))) continue;
                BlockState state = (BlockState)((BlockState)((BlockState)TFMGBlocks.STATOR.getDefaultState().m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)direction.m_122424_())).m_61124_(StatorBlock.STATOR_STATE, (Comparable)((Object)StatorBlock.StatorState.CORNER))).m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(false));
                if (direction == Direction.UP) {
                    state = (BlockState)state.m_61124_((Property)StatorBlock.VALUE, (Comparable)Boolean.valueOf(true));
                }
                if (direction2 == Direction.EAST) {
                    state = (BlockState)state.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)Direction.SOUTH);
                }
                if (direction2 == Direction.NORTH) {
                    state = (BlockState)state.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)Direction.EAST);
                }
                if (direction2 == Direction.SOUTH) {
                    state = (BlockState)state.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)Direction.WEST);
                }
                this.f_58857_.m_7731_(pos, state, 2);
                this.statorBlocks.add(pos);
                ((StatorBlockEntity)this.f_58857_.m_7702_(pos)).setRotor(this);
            }
        }
    }

    public boolean canUseStator(BlockPos pos) {
        return this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.STATOR.get()) && (((StatorBlockEntity)this.f_58857_.m_7702_((BlockPos)pos)).rotor == null || ((StatorBlockEntity)this.f_58857_.m_7702_((BlockPos)pos)).rotor == this.m_58899_());
    }
}

