/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.large_generator;

import com.drmangotea.tfmg.blocks.electricity.base.WallMountBlock;
import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.RotorBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.generation.large_generator.StatorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class StatorBlock
extends WallMountBlock
implements IBE<StatorBlockEntity>,
IWrenchable {
    public static final BooleanProperty VALUE = BooleanProperty.m_61465_((String)"value");
    public static final EnumProperty<StatorState> STATOR_STATE = EnumProperty.m_61587_((String)"stator_state", StatorState.class);

    public StatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{STATOR_STATE}).m_61104_(new Property[]{VALUE});
        super.m_7926_(pBuilder);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockEntity be1 = level.m_7702_(pos = context.m_8083_());
        if (be1 instanceof StatorBlockEntity) {
            StatorBlockEntity be = (StatorBlockEntity)be1;
            if (be.rotor == null) {
                level.m_7731_(pos, (BlockState)state.m_61124_(STATOR_STATE, (Comparable)((Object)StatorState.UNUSED)), 2);
                return InteractionResult.SUCCESS;
            }
            if (state.m_61143_(STATOR_STATE) == StatorState.SIDE) {
                RotorBlockEntity rotor = (RotorBlockEntity)level.m_7702_(be.rotor);
                if (!be.hasOutput) {
                    if (rotor == null) {
                        return InteractionResult.PASS;
                    }
                    for (BlockPos otherPos : rotor.statorBlocks) {
                        BlockEntity blockEntity = level.m_7702_(otherPos);
                        if (!(blockEntity instanceof StatorBlockEntity)) continue;
                        StatorBlockEntity otherStator = (StatorBlockEntity)blockEntity;
                        if (!otherStator.hasOutput) continue;
                        return InteractionResult.PASS;
                    }
                    be.hasOutput = true;
                    return InteractionResult.SUCCESS;
                }
                be.hasOutput = false;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Class<StatorBlockEntity> getBlockEntityClass() {
        return StatorBlockEntity.class;
    }

    public BlockEntityType<? extends StatorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.STATOR.get();
    }

    public static enum StatorState implements StringRepresentable
    {
        UNUSED("unused"),
        SIDE("side"),
        CORNER("corner");

        final String name;

        private StatorState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

