/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.lights;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.WallMountBlock;
import com.drmangotea.tfmg.blocks.electricity.lights.LightBulbBlock;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightBulbBlockEntity
extends ElectricBlockEntity {
    public LerpedFloat glow = LerpedFloat.linear();
    boolean signalChanged;
    boolean hasSignal;

    public LightBulbBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.hasSignal && this.energy.getEnergyStored() != 0) {
            this.glow.chase((double)this.voltage, 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
            if (this.voltage != 0) {
                this.useEnergy(1);
            }
            if (Math.min(this.voltage / 10, 15) != (Integer)this.m_58900_().m_61143_((Property)LightBulbBlock.LIGHT)) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)LightBulbBlock.LIGHT, (Comparable)Integer.valueOf(Math.min(this.voltage / 10, 15))), 2);
            }
        } else {
            if ((Integer)this.m_58900_().m_61143_((Property)LightBulbBlock.LIGHT) != 0) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)LightBulbBlock.LIGHT, (Comparable)Integer.valueOf(0)), 2);
            }
            this.glow.chase(0.0, 0.4, LerpedFloat.Chaser.EXP);
            this.glow.tickChaser();
        }
        if (this.signalChanged) {
            this.signalChanged = false;
            this.analogSignalChanged(this.f_58857_.m_277086_(this.f_58858_));
        }
    }

    public void neighbourChanged() {
        boolean powered;
        if (!this.m_58898_()) {
            return;
        }
        boolean bl = powered = this.f_58857_.m_277086_(this.f_58858_) > 0;
        if (powered != this.hasSignal) {
            this.signalChanged = true;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.neighbourChanged();
    }

    protected void analogSignalChanged(int newSignal) {
        this.hasSignal = newSignal > 0;
    }

    @Override
    public void explode() {
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 2.0f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
        this.f_58857_.m_46961_(this.m_58899_(), false);
        this.sendStuff();
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)WallMountBlock.FACING)).m_122424_();
    }
}

