/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.polarizer;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class PolarizerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public SmartInventory inventory = new SmartInventory(1, (SyncedBlockEntity)this).forbidInsertion().withMaxStackSize(1);
    public int timer = 0;

    public PolarizerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.voltage < 200) {
            this.timer = 0;
            return;
        }
        if (!this.inventory.m_8020_(0).m_150930_((Item)TFMGItems.STEEL_INGOT.get())) {
            this.timer = 0;
            return;
        }
        if (this.energy.getEnergyStored() != 0) {
            this.useEnergy(250);
            if (!this.inventory.m_7983_()) {
                if (this.timer < 100) {
                    ++this.timer;
                } else {
                    this.timer = 0;
                    this.inventory.setStackInSlot(0, TFMGItems.MAGNETIC_INGOT.asStack());
                    TFMGUtils.spawnElectricParticles(this.f_58857_, this.m_58899_());
                    this.sendStuff();
                }
            }
        } else {
            this.timer = 0;
        }
    }

    public void destroy() {
        super.destroy();
        Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.inventory.getStackInSlot(0));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemCapability.cast() : super.getCapability(cap, side);
    }

    public boolean playerInteract(Player player, InteractionHand hand) {
        if (this.inventory.m_7983_()) {
            if (player.m_21120_(hand).m_150930_((Item)TFMGItems.STEEL_INGOT.get())) {
                this.inventory.setStackInSlot(0, TFMGItems.STEEL_INGOT.asStack());
                this.sendStuff();
                player.m_21120_(hand).m_41774_(1);
                return true;
            }
        } else if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, this.inventory.m_8020_(0));
            this.inventory.setStackInSlot(0, Blocks.f_50016_.m_5456_().m_7968_());
            this.sendStuff();
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.energy.getEnergyStored() == 0) {
            Lang.translate((String)"goggles.electric_machine.no_power", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        if (this.energy.getEnergyStored() == 0) {
            Lang.translate((String)"goggles.electric_machine.insufficient_voltage", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            return true;
        }
        if (this.timer > 0) {
            Lang.translate((String)"goggles.blast_furnace.status.running", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            Lang.translate((String)"goggles.coke_oven.progress", (Object[])new Object[]{this.timer}).style(ChatFormatting.GREEN).add(Lang.translate((String)"goggles.misc.percent_symbol", (Object[])new Object[0]).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        } else {
            Lang.translate((String)"goggles.blast_furnace.status.off", (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    public void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        super.write(tag, clientPacket);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        super.read(tag, clientPacket);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
    }
}

