/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.resistors;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.IElectricBlock;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ResistorBlockEntity
extends ElectricBlockEntity {
    protected ScrollValueBehaviour outputVoltage;

    public ResistorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.outputVoltage = new ScrollValueBehaviour((Component)Lang.translateDirect((String)"resistor.allowed_voltage", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ResistorValueBox());
        this.outputVoltage.between(0, max);
        this.outputVoltage.value = 50;
        behaviours.add((BlockEntityBehaviour)this.outputVoltage);
    }

    public void updateVoltageOutput() {
    }

    public int getVoltageOutput() {
        return Math.min(this.outputVoltage.getValue(), this.voltage);
    }

    @Override
    public void tick() {
        IElectricBlock be2;
        super.tick();
        BlockEntity be1 = this.f_58857_.m_7702_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (be1 instanceof IElectricBlock && (be2 = (IElectricBlock)be1).hasElectricitySlot(((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_())) {
            this.sendCharge(be2);
        }
    }

    public void sendCharge(IElectricBlock be) {
        int maxPossibleTransfer = Math.min(this.transferSpeed(), Math.min(this.energy.getEnergyStored(), be.getForgeEnergy().getMaxEnergyStored() - be.getForgeEnergy().getEnergyStored()));
        if (be.getForgeEnergy().getEnergyStored() < this.getForgeEnergy().getEnergyStored()) {
            be.getForgeEnergy().receiveEnergy(maxPossibleTransfer, false);
            this.getForgeEnergy().extractEnergy(maxPossibleTransfer, false);
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    @Override
    public float maxVoltage() {
        return 1500.0f;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
    }

    class ResistorValueBox
    extends ValueBoxTransform.Sided {
        ResistorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return super.getLocalOffset(state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.cast((PoseStack)ms).rotateZ((double)(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (direction != Direction.UP) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

