/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.transformer;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.transformer.CoilBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CoilBlockEntity
extends ElectricBlockEntity {
    public boolean controller = false;
    public int height = 1;
    public float generation = 0.0f;
    ArrayList<CoilBlockEntity> coils = new ArrayList();

    public CoilBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    public float maxVoltage() {
        return 15000.0f;
    }

    @Override
    public void tick() {
        super.tick();
        this.controller = !(this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60734_() instanceof CoilBlock);
        if (((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue() && !this.controller) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CoilBlock.CAN_EXTRACT, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) {
            return;
        }
        if (this.controller) {
            for (CoilBlockEntity coil : this.coils) {
                CoilBlockEntity be;
                BlockEntity blockEntity;
                if (coil == null || !((blockEntity = this.f_58857_.m_7702_(coil.m_58899_())) instanceof CoilBlockEntity) || (be = (CoilBlockEntity)blockEntity).m_58899_() == this.m_58899_()) continue;
                float heightRatio = (float)be.height / (float)this.height;
                if (!((Boolean)be.m_58900_().m_61143_((Property)CoilBlock.CAN_EXTRACT)).booleanValue()) continue;
                be.generation = (float)this.voltage * heightRatio;
                if (this.energy.getEnergyStored() == 0) continue;
                int amount = this.getForgeEnergy().extractEnergy(this.transferSpeed() * 10, true);
                int amount2 = be.getForgeEnergy().receiveEnergy(this.transferSpeed() * 10, true);
                this.getForgeEnergy().extractEnergy(Math.min(amount, amount2), false);
                be.getForgeEnergy().receiveEnergy(Math.min(amount, amount2), false);
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        BlockPos pos = this.m_58899_().m_7495_();
        int height = 1;
        for (int i = 0; i < 4 && this.f_58857_.m_8055_(pos).m_60734_() instanceof CoilBlock; ++i) {
            ++height;
            pos = pos.m_7495_();
        }
        this.height = height;
        this.coils = new ArrayList();
        if (this.controller) {
            for (BlockPos checkedPos : BlockPos.m_121940_((BlockPos)new BlockPos((int)this.reachZone().f_82288_, (int)this.reachZone().f_82289_, (int)this.reachZone().f_82290_), (BlockPos)new BlockPos((int)this.reachZone().f_82291_, (int)this.reachZone().f_82292_, (int)this.reachZone().f_82293_))) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(checkedPos);
                if (!(blockEntity instanceof CoilBlockEntity)) continue;
                CoilBlockEntity be = (CoilBlockEntity)blockEntity;
                if (checkedPos == this.m_58899_() || !be.controller) continue;
                this.coils.add((CoilBlockEntity)this.f_58857_.m_7702_(checkedPos));
            }
        }
    }

    public AABB reachZone() {
        AABB reach = new AABB(this.m_58899_()).m_82400_((double)this.height / 2.0);
        return reach;
    }

    @Override
    public int voltageGeneration() {
        return (int)this.generation;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == Direction.UP;
    }
}

