/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import java.util.function.Consumer;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class BlockPosForEach {
    private BlockPosForEach() {
        throw new IllegalStateException("Can not instantiate an instance of: BlockPosForEach. This is a utility class");
    }

    public static void forEachInRange(int size, Consumer<BlockPos> consumer) {
        BlockPosForEach.forEachInRange(size, size, size, consumer);
    }

    public static void forEachInRange(int xSize, int ySize, int zSize, Consumer<BlockPos> consumer) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    pos.m_122178_(x, y, z);
                    consumer.accept((BlockPos)pos);
                }
            }
        }
    }

    public static void forEachInRange(Vec3 min, Vec3 max, Consumer<BlockPos> consumer) {
        BlockPos minPos = VectorUtils.toBlockPos(min);
        BlockPos maxPos = VectorUtils.toBlockPos(max);
        BlockPosForEach.forEachInRange(minPos.m_123341_(), minPos.m_123342_(), minPos.m_123343_(), maxPos.m_123341_(), maxPos.m_123342_(), maxPos.m_123343_(), consumer);
    }

    public static void forEachInRange(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Consumer<BlockPos> consumer) {
        if (minX == maxX && minY == maxY && minZ == maxZ) {
            consumer.accept(new BlockPos(minX, minY, minZ));
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    consumer.accept((BlockPos)pos);
                }
            }
        }
    }
}

