/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import org.jetbrains.annotations.NotNull;

public enum ModRenderTypes {
    MEASUREMENT_LINES(() -> InternalType.MEASUREMENT_LINES),
    CHISEL_PREVIEW_INSIDE_BLOCKS(() -> InternalType.CHISEL_PREVIEW_INSIDE_BLOCKS),
    CHISEL_PREVIEW_OUTSIDE_BLOCKS(() -> InternalType.CHISEL_PREVIEW_OUTSIDE_BLOCKS),
    WIREFRAME_LINES(() -> InternalType.WIREFRAME_LINES),
    WIREFRAME_LINES_ALWAYS(() -> InternalType.WIREFRAME_LINES_ALWAYS),
    WIREFRAME_BODY(() -> InternalType.WIREFRAME_BODY),
    GHOST_BLOCK_PREVIEW(() -> InternalType.GHOST_BLOCK_PREVIEW),
    GHOST_BLOCK_PREVIEW_GREATER(() -> InternalType.GHOST_BLOCK_PREVIEW_GREATER),
    GHOST_BLOCK_COLORED_PREVIEW(() -> InternalType.GHOST_BLOCK_COLORED_PREVIEW),
    GHOST_BLOCK_COLORED_PREVIEW_ALWAYS(() -> InternalType.GHOST_BLOCK_COLORED_PREVIEW_ALWAYS);

    private final Supplier<RenderType> typeSupplier;

    private ModRenderTypes(Supplier<RenderType> typeSupplier) {
        this.typeSupplier = typeSupplier;
    }

    public RenderType get() {
        return this.typeSupplier.get();
    }

    private static class InternalType
    extends RenderType {
        private static final RenderType MEASUREMENT_LINES = RenderType.m_173215_((String)"chiselsandbits:measurement_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(InternalState.DISABLED_DEPTH_TEST).m_110691_(false));
        private static final RenderType CHISEL_PREVIEW_INSIDE_BLOCKS = RenderType.m_173215_((String)"chiselsandbits:chisel_preview_inside_blocks", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_((RenderStateShard.DepthTestStateShard)InternalState.GREATER_OR_EQUAL_DEPTH_TEST).m_110691_(false));
        private static final RenderType CHISEL_PREVIEW_OUTSIDE_BLOCKS = RenderType.m_173215_((String)"chiselsandbits:chisel_preview_outside_blocks", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.5))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_((RenderStateShard.DepthTestStateShard)InternalState.LESS_OR_EQUAL_DEPTH_TEST).m_110691_(false));
        private static final RenderType WIREFRAME_LINES = InternalType.buildWireframeType(false);
        private static final RenderType WIREFRAME_LINES_ALWAYS = InternalType.buildWireframeType(true);
        private static final RenderType WIREFRAME_BODY = RenderType.m_173215_((String)"chiselsandbits:wireframe_body", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173105_).m_110669_(f_110119_).m_110685_(f_110134_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110111_).m_110691_(false));
        private static final RenderStateShard.TextureStateShard BLOCK_TEXTURE = new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, false);
        private static final RenderStateShard.DepthTestStateShard GREATER_DEPTH_TEST = new RenderStateShard.DepthTestStateShard(">", 516);
        private static final RenderType GHOST_BLOCK_PREVIEW = InternalType.buildGhostType(false);
        private static final RenderType GHOST_BLOCK_PREVIEW_GREATER = InternalType.buildGhostType(true);
        private static final RenderType GHOST_BLOCK_COLORED_PREVIEW = InternalType.buildColoredGhostType(false);
        private static final RenderType GHOST_BLOCK_COLORED_PREVIEW_ALWAYS = InternalType.buildColoredGhostType(true);

        private static RenderType buildWireframeType(boolean always) {
            return RenderType.m_173215_((String)("chiselsandbits:wireframe_lines" + (always ? "_always" : "")), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110125_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(always ? InternalState.DISABLED_DEPTH_TEST : f_110113_).m_110691_(false));
        }

        private static RenderType buildGhostType(boolean greater) {
            if (!greater) {
                return Sheets.m_110792_();
            }
            return RenderType.m_173215_((String)"chiselsandbits:ghost_block_preview_greater", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173065_).m_173290_((RenderStateShard.EmptyTextureStateShard)BLOCK_TEXTURE).m_110685_(f_110139_).m_110671_(f_110152_).m_110677_(f_110154_).m_110663_(GREATER_DEPTH_TEST).m_110691_(false));
        }

        private static RenderType buildColoredGhostType(boolean always) {
            return RenderType.m_173215_((String)("chiselsandbits:ghost_block_colored_preview" + (always ? "_always" : "")), (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_110663_(always ? InternalState.DISABLED_DEPTH_TEST : f_110113_).m_110691_(false));
        }

        private InternalType(String name, VertexFormat fmt, VertexFormat.Mode glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated");
        }
    }

    private static class InternalState
    extends RenderStateShard {
        private static final RenderStateShard.DepthTestStateShard DISABLED_DEPTH_TEST = new DepthTestDisabled();
        private static final DepthTestLessOrEqual LESS_OR_EQUAL_DEPTH_TEST = new DepthTestLessOrEqual();
        private static final DepthTestGreaterOrEqual GREATER_OR_EQUAL_DEPTH_TEST = new DepthTestGreaterOrEqual();

        public InternalState(String name, Runnable setupState, Runnable clearState) {
            super(name, setupState, clearState);
            throw new IllegalStateException("This class must not be instantiated");
        }

        private static class DepthTestDisabled
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestDisabled() {
                super("depth_test_disabled", 0);
            }

            public void m_110185_() {
                RenderSystem.disableDepthTest();
            }

            public void m_110188_() {
                RenderSystem.enableDepthTest();
            }

            @NotNull
            public String toString() {
                return this.f_110133_ + "[chiselsandbits:depth_test_disabled]";
            }
        }

        private static class DepthTestLessOrEqual
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestLessOrEqual() {
                super("depth_test_less_or_equal", 0);
            }

            public void m_110185_() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            public void m_110188_() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            @NotNull
            public String toString() {
                return this.f_110133_ + "[chiselsandbits:depth_test_less_or_equal]";
            }
        }

        private static class DepthTestGreaterOrEqual
        extends RenderStateShard.DepthTestStateShard {
            public DepthTestGreaterOrEqual() {
                super("depth_test_greater_or_equal", 0);
            }

            public void m_110185_() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)518);
            }

            public void m_110188_() {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }

            @NotNull
            public String toString() {
                return this.f_110133_ + "[chiselsandbits:depth_test_greater_or_equal]";
            }
        }
    }
}

