/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.modification.operation;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import java.util.Optional;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.modification.operation.IModificationOperationGroup;
import mod.chiselsandbits.api.multistate.mutator.IGenerallyModifiableAreaMutator;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.registrars.ModModificationOperationGroups;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RotateAroundAxisModificationOperation
extends AbstractCustomRegistryEntry
implements IModificationOperation {
    private final Direction.Axis axis;

    private RotateAroundAxisModificationOperation(Direction.Axis axis) {
        this.axis = axis;
    }

    @Override
    public void apply(IGenerallyModifiableAreaMutator source) {
        source.rotate(this.axis);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return ModModificationOperationGroups.ROTATE.getIcon();
    }

    @Override
    @NotNull
    public Optional<IModificationOperationGroup> getGroup() {
        return Optional.of(ModModificationOperationGroups.ROTATE);
    }

    @Override
    public Component getDisplayName() {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> LocalStrings.PatternModificationAcrossXAxis.getText();
            case Direction.Axis.Y -> LocalStrings.PatternModificationAcrossYAxis.getText();
            case Direction.Axis.Z -> LocalStrings.PatternModificationAcrossZAxis.getText();
        };
    }

    public static final class Builder {
        private Direction.Axis axis;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder withAxis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        public RotateAroundAxisModificationOperation build() {
            return new RotateAroundAxisModificationOperation(this.axis);
        }
    }
}

