/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.client.model.RopeModel;
import net.satisfy.brewery.util.rope.RopeHelper;
import net.satisfy.brewery.util.rope.UVCord;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RopeRender {
    private static final float SCALE = 1.0f;
    private static final float QUALITY = 4.0f;
    private static final int MAX_SEGMENTS = 2048;
    private static final Vec3 POSITIVE_Y = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 NEGATIVE_Y = new Vec3(0.0, -1.0, 0.0);
    private final Map<Integer, RopeModel> models = new HashMap<Integer, RopeModel>(256);

    public void render(VertexConsumer vertexConsumer, PoseStack poseStack, Vec3 ropeVec, int entityId, int blockLight0, int blockLight1, int skyLight0, int skyLight1) {
        RopeModel model;
        int hash = this.getVectorHash(ropeVec, entityId);
        if (this.models.containsKey(hash)) {
            model = this.models.get(hash);
        } else {
            model = this.buildModel(ropeVec);
            this.models.put(hash, model);
        }
        model.render(vertexConsumer, poseStack, blockLight0, blockLight1, skyLight0, skyLight1);
    }

    private RopeModel buildModel(Vec3 ropeVec) {
        float desiredSegmentLength = 0.25f;
        int initialCapacity = (int)(2.0 * ropeVec.m_82556_() / (double)desiredSegmentLength);
        RopeModel.Builder builder = RopeModel.builder(initialCapacity);
        this.createModel(builder, ropeVec, 45, UVCord.DEFAULT_ROPE_H);
        this.createModel(builder, ropeVec, -45, UVCord.DEFAULT_ROPE_V);
        return builder.build();
    }

    private void createModel(RopeModel.Builder builder, Vec3 ropeVec, int degrees, UVCord uv) {
        float length = (float)ropeVec.m_82553_();
        Vec3 ropeNormal = ropeVec.m_82541_();
        Quaternionf quaternion = new Quaternionf().rotateAxis((float)degrees, (float)ropeNormal.m_7096_(), (float)ropeNormal.m_7098_(), (float)ropeNormal.m_7094_());
        Vector3f crossVec = ropeNormal.equals((Object)POSITIVE_Y) || ropeNormal.equals((Object)NEGATIVE_Y) ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f((float)ropeNormal.m_82537_((Vec3)RopeRender.POSITIVE_Y).m_82541_().f_82479_, (float)ropeNormal.m_82537_((Vec3)RopeRender.POSITIVE_Y).m_82541_().f_82480_, (float)ropeNormal.m_82537_((Vec3)RopeRender.POSITIVE_Y).m_82541_().f_82481_);
        crossVec.rotate((Quaternionfc)quaternion);
        crossVec.mul((uv.x1() - uv.x0()) / 16.0f * 1.0f);
        crossVec.mul(0.5f);
        float uvEnd = 0.0f;
        double segmentLength = Math.min(length, 0.25f);
        Vector3f currentPos = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f lastPos = new Vector3f();
        Vector3f segmentVector = new Vector3f((float)ropeNormal.m_82542_((double)segmentLength, (double)segmentLength, (double)segmentLength).f_82479_, (float)ropeNormal.m_82542_((double)segmentLength, (double)segmentLength, (double)segmentLength).f_82480_, (float)ropeNormal.m_82542_((double)segmentLength, (double)segmentLength, (double)segmentLength).f_82481_);
        Vector3f segmentPos = new Vector3f(0.0f, 0.0f, 0.0f);
        boolean lastIter = false;
        boolean straight = ropeVec.f_82479_ == 0.0 && ropeVec.f_82481_ == 0.0;
        for (int segment = 0; segment < 2048; ++segment) {
            block6: {
                block5: {
                    lastPos.set((Vector3fc)currentPos);
                    segmentPos.add((Vector3fc)segmentVector);
                    if (straight) break block5;
                    Vec3 vec3 = new Vec3(segmentPos);
                    if (!(vec3.m_82553_() > (double)length)) break block6;
                }
                lastIter = true;
                segmentPos.set((float)ropeVec.f_82479_, (float)ropeVec.f_82480_, (float)ropeVec.f_82481_);
            }
            currentPos.set((Vector3fc)segmentPos);
            if (!straight) {
                currentPos.add(0.0f, (float)RopeHelper.getYHanging(new Vec3(segmentPos).m_82553_(), ropeVec), 0.0f);
            }
            double actuallySegmentLength = new Vec3(currentPos).m_82554_(new Vec3(lastPos));
            float uvStart = uvEnd;
            builder.vertex(lastPos.x() - crossVec.x(), lastPos.y() - crossVec.y(), lastPos.z() - crossVec.z()).uv(uv.x0() / 16.0f, uvStart).next();
            builder.vertex(lastPos.x() + crossVec.x(), lastPos.y() + crossVec.y(), lastPos.z() + crossVec.z()).uv(uv.x1() / 16.0f, uvStart).next();
            builder.vertex(currentPos.x() + crossVec.x(), currentPos.y() + crossVec.y(), currentPos.z() + crossVec.z()).uv(uv.x1() / 16.0f, uvEnd += (float)(actuallySegmentLength / 1.0)).next();
            builder.vertex(currentPos.x() - crossVec.x(), currentPos.y() - crossVec.y(), currentPos.z() - crossVec.z()).uv(uv.x0() / 16.0f, uvEnd).next();
            if (lastIter) break;
        }
    }

    private int getVectorHash(Vec3 ropeVec, int id) {
        return Objects.hash(id, ropeVec.f_82479_, ropeVec.f_82480_, ropeVec.f_82481_);
    }
}

