/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.block.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.nethervinery.registry.NetherBlockEntityTypes;
import net.satisfy.vinery.client.gui.handler.FermentationBarrelGuiHandler;
import net.satisfy.vinery.registry.ObjectRegistry;
import net.satisfy.vinery.registry.RecipeTypesRegistry;
import net.satisfy.vinery.util.WineYears;
import org.jetbrains.annotations.Nullable;

public class AgingBarrelBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<AgingBarrelBlockEntity>,
MenuProvider {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 6;
    private static final int BOTTLE_INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 5;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private static final int[] SLOTS_FOR_SIDE = new int[]{0};
    private static final int[] SLOTS_FOR_UP = new int[]{1, 2, 3, 4};
    private static final int[] SLOTS_FOR_DOWN = new int[]{5};
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AgingBarrelBlockEntity.this.fermentationTime;
                case 1 -> AgingBarrelBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AgingBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    AgingBarrelBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public AgingBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)NetherBlockEntityTypes.AGING_BARREL_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128448_("FermentationTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128376_("FermentationTime", (short)this.fermentationTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, AgingBarrelBlockEntity blockEntity) {
        RegistryAccess access;
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        Recipe recipe = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get(), (Container)this, world).orElse(null);
        if (this.canCraft(recipe, access = this.f_58857_.m_9598_())) {
            ++this.fermentationTime;
            if (this.fermentationTime >= this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipe, access);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft(Recipe<?> recipe, RegistryAccess access) {
        if (recipe == null || recipe.m_8043_(access).m_41619_()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            return false;
        }
        Item item = this.m_8020_(0).m_41720_();
        if (item != ((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_()) {
            return false;
        }
        return this.m_8020_(5).m_41619_();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i < 5; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 4;
    }

    private void craft(Recipe<?> recipe, RegistryAccess access) {
        ItemStack bottle;
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(access);
        ItemStack outputSlotStack = this.m_8020_(5);
        if (outputSlotStack.m_41619_()) {
            ItemStack output = recipeOutput.m_41777_();
            WineYears.setWineYear((ItemStack)output, (Level)this.f_58857_);
            this.m_6836_(5, output);
        }
        if ((bottle = this.m_8020_(0)).m_41613_() > 1) {
            this.m_7407_(0, 1);
        } else if (bottle.m_41613_() == 1) {
            this.m_6836_(0, ItemStack.f_41583_);
        }
        for (Ingredient entry : recipe.m_7527_()) {
            if (entry.test(this.m_8020_(1))) {
                this.m_7407_(1, 1);
            }
            if (entry.test(this.m_8020_(2))) {
                this.m_7407_(2, 1);
            }
            if (entry.test(this.m_8020_(3))) {
                this.m_7407_(3, 1);
            }
            if (!entry.test(this.m_8020_(4))) continue;
            this.m_7407_(4, 1);
        }
    }

    public int[] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 0 && slot != 2 && slot != 3 && slot != 4 && slot != 5 || dirty)) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new FermentationBarrelGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

