/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.registry;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.FacingBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.satisfy.nethervinery.block.AgingBarrelBlock;
import net.satisfy.nethervinery.block.ApplePressBlock;
import net.satisfy.nethervinery.block.CrimsonGrapeBush;
import net.satisfy.nethervinery.block.ImprovedWineBottleBlock;
import net.satisfy.nethervinery.block.WarpedGrapeBush;
import net.satisfy.nethervinery.registry.NetherEffects;
import net.satisfy.nethervinery.registry.NetherGrapeTypes;
import net.satisfy.nethervinery.util.NetherVineryIdentifier;
import net.satisfy.vinery.block.GrapevinePotBlock;
import net.satisfy.vinery.block.stem.LatticeBlock;
import net.satisfy.vinery.block.stem.PaleStemBlock;
import net.satisfy.vinery.block.storage.BigBottleStorageBlock;
import net.satisfy.vinery.block.storage.FourBottleStorageBlock;
import net.satisfy.vinery.block.storage.NineBottleStorageBlock;
import net.satisfy.vinery.block.storage.WineBottleBlock;
import net.satisfy.vinery.item.DrinkBlockBigItem;
import net.satisfy.vinery.item.DrinkBlockSmallItem;
import net.satisfy.vinery.item.GrapeBushSeedItem;
import net.satisfy.vinery.item.GrapeItem;
import net.satisfy.vinery.registry.MobEffectRegistry;
import net.satisfy.vinery.util.FoodComponent;

public class NetherObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"nethervinery", (ResourceKey)Registries.f_256913_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"nethervinery", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> OBSIDIAN_STEM = NetherObjectRegistry.registerWithItem("obsidian_stem", () -> new PaleStemBlock(NetherObjectRegistry.getGrapevineSettings()));
    public static final RegistrySupplier<Item> CRIMSON_NETHER_BAG = NetherObjectRegistry.registerI("crimson_nether_bag", () -> new BundleItem(NetherObjectRegistry.getSettings().m_41487_(1)));
    public static final RegistrySupplier<Item> WARPED_NETHER_BAG = NetherObjectRegistry.registerI("warped_nether_bag", () -> new BundleItem(NetherObjectRegistry.getSettings().m_41487_(1)));
    public static final RegistrySupplier<Block> CRIMSON_GRAPE_BUSH = NetherObjectRegistry.registerB("crimson_grape_bush", () -> new CrimsonGrapeBush(NetherObjectRegistry.getBushSettings(), NetherGrapeTypes.CRIMSON));
    public static final RegistrySupplier<Block> WARPED_GRAPE_BUSH = NetherObjectRegistry.registerB("warped_grape_bush", () -> new WarpedGrapeBush(NetherObjectRegistry.getBushSettings(), NetherGrapeTypes.WARPED));
    public static final RegistrySupplier<Item> CRIMSON_GRAPE_SEEDS = NetherObjectRegistry.registerI("crimson_grape_seeds", () -> new GrapeBushSeedItem((Block)CRIMSON_GRAPE_BUSH.get(), NetherObjectRegistry.getSettings(), NetherGrapeTypes.CRIMSON));
    public static final RegistrySupplier<Item> CRIMSON_GRAPE = NetherObjectRegistry.registerI("crimson_grape", () -> new GrapeItem(NetherObjectRegistry.getSettings().m_41489_(Foods.f_38808_), NetherGrapeTypes.CRIMSON, (Item)CRIMSON_GRAPE_SEEDS.get()));
    public static final RegistrySupplier<Item> WARPED_GRAPE_SEEDS = NetherObjectRegistry.registerI("warped_grape_seeds", () -> new GrapeBushSeedItem((Block)WARPED_GRAPE_BUSH.get(), NetherObjectRegistry.getSettings(), NetherGrapeTypes.WARPED));
    public static final RegistrySupplier<Item> WARPED_GRAPE = NetherObjectRegistry.registerI("warped_grape", () -> new GrapeItem(NetherObjectRegistry.getSettings().m_41489_(Foods.f_38808_), NetherGrapeTypes.WARPED, (Item)WARPED_GRAPE_SEEDS.get()));
    public static final RegistrySupplier<Block> WARPED_GRAPE_CRATE = NetherObjectRegistry.registerWithItem("warped_grape_crate", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_)));
    public static final RegistrySupplier<Block> CRIMSON_GRAPE_GRATE = NetherObjectRegistry.registerWithItem("crimson_grape_crate", () -> new FacingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50108_)));
    public static final RegistrySupplier<Item> WARPED_GRAPEJUICE = NetherObjectRegistry.registerI("warped_grapejuice", () -> new Item(NetherObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> CRIMSON_GRAPEJUICE = NetherObjectRegistry.registerI("crimson_grapejuice", () -> new Item(NetherObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> GHASTLY_GRENACHE = NetherObjectRegistry.registerB("ghastly_grenache", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 2));
    public static final RegistrySupplier<Item> GHASTLY_GRENACHE_ITEM = NetherObjectRegistry.registerI("ghastly_grenache", () -> new DrinkBlockBigItem((Block)GHASTLY_GRENACHE.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)MobEffectRegistry.IMPROVED_JUMP_BOOST.get(), 1200)));
    public static final RegistrySupplier<Block> NETHERITE_NECTAR = NetherObjectRegistry.registerB("netherite_nectar", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<Item> NETHERITE_NECTAR_ITEM = NetherObjectRegistry.registerI("netherite_nectar", () -> new DrinkBlockSmallItem((Block)NETHERITE_NECTAR.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)NetherEffects.NETHERITE.get(), 240)));
    public static final RegistrySupplier<Block> BLAZEWINE_PINOT = NetherObjectRegistry.registerB("blazewine_pinot", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 1));
    public static final RegistrySupplier<Item> BLAZEWINE_PINOT_ITEM = NetherObjectRegistry.registerI("blazewine_pinot", () -> new DrinkBlockBigItem((Block)BLAZEWINE_PINOT.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)MobEffectRegistry.LAVA_WALKER.get(), 1200)));
    public static final RegistrySupplier<Block> NETHER_FIZZ = NetherObjectRegistry.registerB("nether_fizz", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 2));
    public static final RegistrySupplier<Item> NETHER_FIZZ_ITEM = NetherObjectRegistry.registerI("nether_fizz", () -> new DrinkBlockSmallItem((Block)NETHER_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)NetherEffects.HEARTHSTONE.get(), 1)));
    public static final RegistrySupplier<Block> LAVA_FIZZ = NetherObjectRegistry.registerB("lava_fizz", () -> new WineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<Item> LAVA_FIZZ_ITEM = NetherObjectRegistry.registerI("lava_fizz", () -> new DrinkBlockSmallItem((Block)LAVA_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)NetherEffects.GRAVEDIGGER.get(), 1)));
    public static final RegistrySupplier<Block> IMPROVED_NETHER_FIZZ = NetherObjectRegistry.registerB("improved_nether_fizz", () -> new ImprovedWineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<Item> IMPROVED_NETHER_FIZZ_ITEM = NetherObjectRegistry.registerI("improved_nether_fizz", () -> new DrinkBlockSmallItem((Block)IMPROVED_NETHER_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)NetherEffects.IMPROVED_HEARTHSTONE.get(), 1)));
    public static final RegistrySupplier<Block> IMPROVED_LAVA_FIZZ = NetherObjectRegistry.registerB("improved_lava_fizz", () -> new ImprovedWineBottleBlock(NetherObjectRegistry.getWineSettings(), 3));
    public static final RegistrySupplier<Item> IMPROVED_LAVA_FIZZ_ITEM = NetherObjectRegistry.registerI("improved_lava_fizz", () -> new DrinkBlockSmallItem((Block)IMPROVED_LAVA_FIZZ.get(), NetherObjectRegistry.getWineItemSettings((MobEffect)NetherEffects.IMPROVED_GRAVEDIGGER.get(), 1)));
    public static final RegistrySupplier<Block> CRIMSON_FERMENTATION_BARREL = NetherObjectRegistry.registerWithItem("crimson_fermentation_barrel", () -> new AgingBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_GRAPEVINE_POT = NetherObjectRegistry.registerWithItem("crimson_grapevine_pot", () -> new GrapevinePotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_APPLE_PRESS = NetherObjectRegistry.registerWithItem("crimson_apple_press", () -> new ApplePressBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_WINE_RACK_BIG = NetherObjectRegistry.registerWithItem("crimson_wine_rack_big", () -> new NineBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_WINE_RACK_SMALL = NetherObjectRegistry.registerWithItem("crimson_wine_rack_small", () -> new FourBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_WINE_RACK_MID = NetherObjectRegistry.registerWithItem("crimson_wine_rack_mid", () -> new BigBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> REINFORCED_CRIMSON_PLANKS = NetherObjectRegistry.registerWithItem("reinforced_crimson_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistrySupplier<Block> CRESTED_CRIMSON_PLANKS = NetherObjectRegistry.registerWithItem("crested_crimson_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistrySupplier<Block> CRIMSON_BARREL = NetherObjectRegistry.registerWithItem("crimson_barrel", () -> new BarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)));
    public static final RegistrySupplier<Block> WARPED_FERMENTATION_BARREL = NetherObjectRegistry.registerWithItem("warped_fermentation_barrel", () -> new AgingBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_GRAPEVINE_POT = NetherObjectRegistry.registerWithItem("warped_grapevine_pot", () -> new GrapevinePotBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_APPLE_PRESS = NetherObjectRegistry.registerWithItem("warped_apple_press", () -> new ApplePressBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_WINE_RACK_BIG = NetherObjectRegistry.registerWithItem("warped_wine_rack_big", () -> new NineBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_WINE_RACK_SMALL = NetherObjectRegistry.registerWithItem("warped_wine_rack_small", () -> new FourBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> WARPED_WINE_RACK_MID = NetherObjectRegistry.registerWithItem("warped_wine_rack_mid", () -> new BigBottleStorageBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistrySupplier<Block> REINFORCED_WARPED_PLANKS = NetherObjectRegistry.registerWithItem("reinforced_warped_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistrySupplier<Block> CRESTED_WARPED_PLANKS = NetherObjectRegistry.registerWithItem("crested_warped_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistrySupplier<Block> WARPED_BARREL = NetherObjectRegistry.registerWithItem("warped_barrel", () -> new BarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)));
    public static final RegistrySupplier<Block> WARPED_LATTICE = NetherObjectRegistry.registerWithItem("warped_lattice", () -> new LatticeBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(Blocks.f_50743_.m_49962_(Blocks.f_50743_.m_49966_())).m_60955_()));
    public static final RegistrySupplier<Block> CRIMSON_LATTICE = NetherObjectRegistry.registerWithItem("crimson_lattice", () -> new LatticeBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(Blocks.f_220865_.m_49962_(Blocks.f_220865_.m_49966_())).m_60955_()));

    private static <T extends Item> RegistrySupplier<T> registerI(String path, Supplier<T> item) {
        NetherVineryIdentifier id = new NetherVineryIdentifier(path);
        return ITEM_REGISTRAR.register((ResourceLocation)id, item);
    }

    private static <T extends Block> RegistrySupplier<T> registerB(String path, Supplier<T> block) {
        NetherVineryIdentifier id = new NetherVineryIdentifier(path);
        return BLOCK_REGISTRAR.register((ResourceLocation)id, block);
    }

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    private static Item.Properties getSettings() {
        return NetherObjectRegistry.getSettings(settings -> {});
    }

    private static BlockBehaviour.Properties getGrapevineSettings() {
        return BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60977_().m_60918_(SoundType.f_56742_).m_60955_();
    }

    private static Item.Properties getWineItemSettings(MobEffect effect, int duration) {
        return NetherObjectRegistry.getSettings().m_41489_(NetherObjectRegistry.wineFoodComponent(effect, duration));
    }

    private static FoodProperties wineFoodComponent(MobEffect effect, int duration) {
        ArrayList effects = Lists.newArrayList();
        if (effect != null) {
            effects.add(Pair.of((Object)new MobEffectInstance(effect, duration), (Object)Float.valueOf(1.0f)));
        }
        return new FoodComponent((List)effects);
    }

    private static BlockBehaviour.Properties getBushSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_);
    }

    private static BlockBehaviour.Properties getWineSettings() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60955_().m_60966_();
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String path, Supplier<T> block) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)new NetherVineryIdentifier(path), block);
    }
}

