/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.satisfy.nethervinery.client.gui.handler.AgingBarrelGuiHandler;
import net.satisfy.nethervinery.client.gui.handler.ApplePressGuiHandler;
import net.satisfy.nethervinery.util.NetherVineryIdentifier;

public class NetherScreenHandlerTypes {
    private static final Registrar<MenuType<?>> MENU_TYPES = DeferredRegister.create((String)"nethervinery", (ResourceKey)Registries.f_256798_).getRegistrar();
    public static final RegistrySupplier<MenuType<ApplePressGuiHandler>> APPLE_PRESS_GUI_HANDLER = NetherScreenHandlerTypes.register("apple_press_gui_handler", () -> new MenuType(ApplePressGuiHandler::new, FeatureFlags.f_244377_));
    public static final RegistrySupplier<MenuType<AgingBarrelGuiHandler>> FERMENTATION_BARREL_GUI_HANDLER = NetherScreenHandlerTypes.register("fermentation_barrel_gui_handler", () -> new MenuType(AgingBarrelGuiHandler::new, FeatureFlags.f_244377_));

    public static <T extends AbstractContainerMenu> RegistrySupplier<MenuType<T>> register(String name, Supplier<MenuType<T>> menuType) {
        return MENU_TYPES.register((ResourceLocation)new NetherVineryIdentifier(name), menuType);
    }

    public static void init() {
    }
}

