/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.api;

import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.ApiList;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.InvalidContextState;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshair.mixin.BlockItemAccessor;
import mod.crend.dynamiccrosshair.mixin.ItemAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CrosshairContext {
    @NotNull
    public ClientLevel world;
    @NotNull
    public final LocalPlayer player;
    @NotNull
    public HitResult hitResult;
    private boolean withBlock = false;
    private BlockPos blockPos = null;
    private BlockState blockState = null;
    private BlockEntity blockEntity = null;
    private boolean withEntity = false;
    private Entity entity = null;
    private InteractionHand hand;
    private ItemStack itemStackMainHand = null;
    private ItemStack itemStackOffHand = null;
    private ApiList apiList = null;

    public CrosshairContext() {
        assert (Minecraft.m_91087_().f_91073_ != null);
        assert (Minecraft.m_91087_().f_91074_ != null);
        assert (Minecraft.m_91087_().f_91077_ != null);
        this.world = Minecraft.m_91087_().f_91073_;
        this.player = Minecraft.m_91087_().f_91074_;
        this.hand = InteractionHand.MAIN_HAND;
        this.hitResult = Minecraft.m_91087_().f_91077_;
        this.invalidateHitResult(this.hitResult);
    }

    public void invalidateHitResult(HitResult newHitResult) {
        assert (newHitResult != null);
        assert (Minecraft.m_91087_().f_91073_ != null);
        this.hitResult = newHitResult;
        this.withBlock = false;
        this.blockPos = null;
        this.blockState = null;
        this.blockEntity = null;
        this.withEntity = false;
        this.entity = null;
        this.apiList = null;
        this.itemStackMainHand = null;
        this.itemStackOffHand = null;
        switch (this.hitResult.m_6662_()) {
            case BLOCK: {
                BlockHitResult blockHitResult = (BlockHitResult)this.hitResult;
                this.withBlock = true;
                this.blockPos = blockHitResult.m_82425_();
                break;
            }
            case ENTITY: {
                EntityHitResult entityHitResult = (EntityHitResult)this.hitResult;
                this.withEntity = true;
                this.entity = entityHitResult.m_82443_();
            }
        }
        this.world = Minecraft.m_91087_().f_91073_;
        for (DynamicCrosshairApi api : this.apis()) {
            try {
                ClientLevel useWorld = api.overrideWorld();
                if (useWorld == null) continue;
                this.world = useWorld;
                break;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException throwable) {
            }
        }
    }

    public void invalidateItem(InteractionHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                this.itemStackMainHand = null;
                break;
            }
            case OFF_HAND: {
                this.itemStackOffHand = null;
            }
        }
    }

    public boolean isTargeting() {
        return this.hitResult.m_6662_() != HitResult.Type.MISS;
    }

    public boolean isEmptyHanded() {
        return this.player.m_21205_().m_41619_() && this.player.m_21206_().m_41619_();
    }

    public boolean shouldInteract() {
        return !this.player.m_36341_() || this.isEmptyHanded();
    }

    public boolean isWithBlock() {
        return this.withBlock;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public BlockState getBlockState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockState(): blockPos is null despite targeted block!");
        }
        if (this.blockState == null) {
            this.blockState = this.world.m_8055_(this.blockPos);
        }
        return this.blockState;
    }

    public Block getBlock() {
        return this.getBlockState().m_60734_();
    }

    public BlockEntity getBlockEntity() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getBlockEntity() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getBlockEntity(): blockPos is null despite targeted block!");
        }
        if (this.blockEntity == null) {
            this.blockEntity = this.world.m_7702_(this.blockPos);
        }
        return this.blockEntity;
    }

    public FluidState getFluidState() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        if (this.blockPos == null) {
            throw new InvalidContextState("In getFluidState(): blockPos is null despite targeted block!");
        }
        return this.world.m_6425_(this.blockPos);
    }

    public BlockHitResult getBlockHitResult() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called getFluidState() without a targeted block!");
        }
        return (BlockHitResult)this.hitResult;
    }

    public Direction getBlockHitSide() {
        return this.getBlockHitResult().m_82434_();
    }

    public BlockHitResult raycastWithFluid(ClipContext.Fluid fluidHandling) {
        return ItemAccessor.invokeRaycast((Level)this.world, (Player)this.player, fluidHandling);
    }

    public BlockHitResult raycastWithFluid() {
        return this.raycastWithFluid(ClipContext.Fluid.ANY);
    }

    public EntityHitResult raycastForEntity(double d) {
        Vec3 vCamPos = this.player.m_20299_(1.0f);
        Vec3 vRotation = this.player.m_20252_(1.0f);
        Vec3 vRaycast = vCamPos.m_82520_(vRotation.f_82479_ * d, vRotation.f_82480_ * d, vRotation.f_82481_ * d);
        AABB box = this.player.m_20191_().m_82369_(vRotation.m_82490_(d)).m_82377_(1.0, 1.0, 1.0);
        return ProjectileUtil.m_37287_((Entity)this.player, (Vec3)vCamPos, (Vec3)vRaycast, (AABB)box, entity -> !entity.m_5833_() && entity.m_5829_(), (double)(d * d));
    }

    public boolean isWithEntity() {
        return this.withEntity;
    }

    public Entity getEntity() {
        if (!this.withEntity) {
            throw new InvalidContextState("Called getEntity() without a targeted entity!");
        }
        if (this.entity == null) {
            throw new InvalidContextState("In getEntity(): entity is null despite targeted entity!");
        }
        return this.entity;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void setHand(InteractionHand hand) {
        this.hand = hand;
    }

    public boolean isMainHand() {
        return this.hand == InteractionHand.MAIN_HAND;
    }

    public boolean isOffHand() {
        return this.hand == InteractionHand.OFF_HAND;
    }

    public ItemStack getItemStack(InteractionHand hand) {
        ItemStack itemStack;
        switch (hand) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MAIN_HAND: {
                ItemStack itemStack2 = this.itemStackMainHand;
                break;
            }
            case OFF_HAND: {
                ItemStack itemStack2 = itemStack = this.itemStackOffHand;
            }
        }
        if (itemStack == null) {
            itemStack = this.player.m_21120_(hand);
            switch (hand) {
                case MAIN_HAND: {
                    this.itemStackMainHand = itemStack;
                    break;
                }
                case OFF_HAND: {
                    this.itemStackOffHand = itemStack;
                }
            }
        }
        return itemStack;
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.hand);
    }

    public Item getItem() {
        return this.getItemStack().m_41720_();
    }

    public boolean isActiveItem() {
        return this.player.m_21211_().equals(this.getItemStack());
    }

    public boolean isCoolingDown() {
        return this.player.m_36335_().m_41519_(this.getItem());
    }

    public boolean canPlaceItemAsBlock() {
        if (!this.withBlock) {
            throw new InvalidContextState("Called canPlaceItemAsBlock() without a targeted block!");
        }
        BlockItemAccessor blockItem = (BlockItemAccessor)this.getItem();
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext((Player)this.player, this.hand, this.getItemStack(), (BlockHitResult)this.hitResult);
        try {
            BlockState blockState = blockItem.invokeGetPlacementState(itemPlacementContext);
            return blockState != null && blockItem.invokeCanPlace(itemPlacementContext, blockState);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean canUseWeaponAsTool() {
        return this.isWithBlock() && DynamicCrosshair.config.dynamicCrosshairHoldingTool() != CrosshairPolicy.Disabled;
    }

    public boolean isRangedWeaponCharged(int bound) {
        return this.isActiveItem() && this.getItem().m_8105_(this.getItemStack()) - this.player.m_21212_() >= bound;
    }

    public boolean includeUsableItem() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingUsableItem()) {
            default -> throw new IncompatibleClassChangeError();
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeThrowable() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingThrowable()) {
            default -> throw new IncompatibleClassChangeError();
            case UsableCrosshairPolicy.Always -> true;
            case UsableCrosshairPolicy.IfInteractable -> {
                if (!this.isCoolingDown()) {
                    yield true;
                }
                yield false;
            }
            case UsableCrosshairPolicy.Disabled -> false;
        };
    }

    public boolean includeRangedWeapon() {
        return DynamicCrosshair.config.dynamicCrosshairHoldingRangedWeapon() != UsableCrosshairPolicy.Disabled;
    }

    public boolean includeMeleeWeapon() {
        return this.isMainHand() && DynamicCrosshair.config.dynamicCrosshairHoldingMeleeWeapon();
    }

    public boolean includeTool() {
        boolean bl;
        block7: {
            block6: {
                if (!this.isMainHand()) break block6;
                switch (DynamicCrosshair.config.dynamicCrosshairHoldingTool()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Always: {
                        break;
                    }
                    case IfTargeting: {
                        if (this.isTargeting()) {
                            break;
                        }
                        break block6;
                    }
                    case Disabled: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public boolean includeShield() {
        return DynamicCrosshair.config.dynamicCrosshairHoldingShield();
    }

    public boolean includeHoldingBlock() {
        return switch (DynamicCrosshair.config.dynamicCrosshairHoldingBlock()) {
            default -> throw new IncompatibleClassChangeError();
            case BlockCrosshairPolicy.Always, BlockCrosshairPolicy.IfInteractable -> true;
            case BlockCrosshairPolicy.IfTargeting -> this.isTargeting();
            case BlockCrosshairPolicy.Disabled -> false;
        };
    }

    public List<DynamicCrosshairApi> apis() {
        if (this.apiList == null) {
            this.apiList = new ApiList();
            this.apiList.add(this.getItemStack(InteractionHand.MAIN_HAND));
            this.apiList.add(this.getItemStack(InteractionHand.OFF_HAND));
            if (this.isWithBlock()) {
                this.apiList.add(this.getBlockState());
            }
            if (this.isWithEntity()) {
                this.apiList.add(this.getEntity());
            }
        }
        return this.apiList.get();
    }
}

