/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.api;

import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.ItemCategory;
import mod.crend.dynamiccrosshair.component.Crosshair;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public interface DynamicCrosshairApi {
    public String getNamespace();

    default public String getModId() {
        return this.getNamespace();
    }

    default public void init() {
    }

    default public boolean forceCheck() {
        return false;
    }

    default public boolean forceInvalidate(CrosshairContext context) {
        return false;
    }

    default public HitResult overrideHitResult(CrosshairContext context, HitResult hitResult) {
        return hitResult;
    }

    default public ClientLevel overrideWorld() {
        return null;
    }

    default public boolean isAlwaysUsableItem(ItemStack itemStack) {
        return false;
    }

    default public boolean isUsableItem(ItemStack itemStack) {
        return false;
    }

    default public ItemCategory getItemCategory(ItemStack itemStack) {
        if (this.isAlwaysUsableItem(itemStack) || this.isUsableItem(itemStack)) {
            return ItemCategory.USABLE;
        }
        return ItemCategory.NONE;
    }

    default public boolean isAlwaysInteractableEntity(Entity entity) {
        return false;
    }

    default public boolean isInteractableEntity(Entity entity) {
        return false;
    }

    default public boolean isAlwaysInteractableBlock(BlockState blockState) {
        return false;
    }

    default public boolean isInteractableBlock(BlockState blockState) {
        return false;
    }

    default public Crosshair computeFromEntity(CrosshairContext context) {
        return null;
    }

    default public Crosshair computeFromBlock(CrosshairContext context) {
        return null;
    }

    default public Crosshair computeFromItem(CrosshairContext context) {
        return null;
    }
}

