/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.CrosshairContextChange;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.InvalidContextState;
import mod.crend.dynamiccrosshair.api.ItemCategory;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairVariant;
import mod.crend.dynamiccrosshair.component.State;
import mod.crend.dynamiccrosshair.config.InteractableCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrosshairHandler {
    public static final ResourceLocation crosshairTexture = new ResourceLocation("dynamiccrosshair", "textures/gui/crosshairs.png");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    private static Crosshair activeCrosshair = new Crosshair();
    private static boolean shouldShowCrosshair = true;
    public static boolean forceShowCrosshair = false;
    static State state = null;

    public static Crosshair getActiveCrosshair() {
        return activeCrosshair;
    }

    private static boolean isBlockInteractable(CrosshairContext context) {
        if (DynamicCrosshair.config.dynamicCrosshairOnBlock() != InteractableCrosshairPolicy.Disabled && context.isWithBlock() && context.shouldInteract()) {
            for (DynamicCrosshairApi api : context.apis()) {
                try {
                    if (!api.isAlwaysInteractableBlock(context.getBlockState()) && !api.isInteractableBlock(context.getBlockState())) continue;
                    return true;
                }
                catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                    if (e instanceof CrosshairContextChange) {
                        throw e;
                    }
                    LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                }
            }
        }
        return false;
    }

    private static Crosshair buildCrosshairAdvancedFromItem(CrosshairContext context) {
        UsableCrosshairPolicy usableItemPolicy = DynamicCrosshair.config.dynamicCrosshairHoldingUsableItem();
        for (DynamicCrosshairApi api : context.apis()) {
            try {
                Crosshair crosshair;
                if (usableItemPolicy != UsableCrosshairPolicy.Disabled) {
                    ItemStack itemStack = context.getItemStack();
                    if ((usableItemPolicy == UsableCrosshairPolicy.Always || !context.isCoolingDown()) && api.isAlwaysUsableItem(itemStack)) {
                        return Crosshair.USABLE;
                    }
                    if (usableItemPolicy == UsableCrosshairPolicy.Always && api.isUsableItem(itemStack)) {
                        return Crosshair.USABLE;
                    }
                }
                if ((crosshair = api.computeFromItem(context)) == null) continue;
                return crosshair;
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                if (e instanceof CrosshairContextChange) {
                    throw e;
                }
                LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
            }
        }
        return null;
    }

    private static Crosshair buildCrosshairAdvancedByHand(CrosshairContext context) {
        Crosshair crosshair;
        block8: {
            block9: {
                crosshair = null;
                if (!context.isWithEntity()) break block9;
                for (DynamicCrosshairApi api : context.apis()) {
                    try {
                        crosshair = api.isAlwaysInteractableEntity(context.getEntity()) ? Crosshair.INTERACTABLE : api.computeFromEntity(context);
                        if (crosshair == null) continue;
                        break block8;
                    }
                    catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                        if (e instanceof CrosshairContextChange) {
                            throw e;
                        }
                        LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                    }
                }
                break block8;
            }
            if (!context.isWithBlock() || !context.shouldInteract()) break block8;
            for (DynamicCrosshairApi api : context.apis()) {
                try {
                    crosshair = api.isAlwaysInteractableBlock(context.getBlockState()) ? Crosshair.INTERACTABLE : api.computeFromBlock(context);
                    if (crosshair == null) continue;
                    break;
                }
                catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                    if (e instanceof CrosshairContextChange) {
                        throw e;
                    }
                    LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                }
            }
        }
        return Crosshair.combine(crosshair, CrosshairHandler.buildCrosshairAdvancedFromItem(context));
    }

    private static Crosshair buildCrosshairAdvanced(CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.buildCrosshairAdvancedByHand(context);
        if (crosshair != null && (crosshair.hasStyle() || crosshair.isLockedStyle()) && (crosshair.hasModifierUse() || crosshair.isLockedModifierUse())) {
            return crosshair;
        }
        context.setHand(InteractionHand.OFF_HAND);
        Crosshair offhandCrosshair = CrosshairHandler.buildCrosshairAdvancedByHand(context);
        context.setHand(InteractionHand.MAIN_HAND);
        if (offhandCrosshair != null) {
            return Crosshair.combine(crosshair, offhandCrosshair);
        }
        return crosshair;
    }

    private static Crosshair buildCrosshairSimple(CrosshairContext context) {
        Crosshair crosshair;
        block31: {
            block30: {
                crosshair = null;
                for (DynamicCrosshairApi api : context.apis()) {
                    try {
                        if ((crosshair = (switch (api.getItemCategory(context.getItemStack())) {
                            case ItemCategory.TOOL -> Crosshair.TOOL;
                            case ItemCategory.MELEE_WEAPON -> Crosshair.MELEE_WEAPON;
                            case ItemCategory.RANGED_WEAPON -> Crosshair.RANGED_WEAPON;
                            case ItemCategory.THROWABLE -> Crosshair.THROWABLE;
                            case ItemCategory.BLOCK -> Crosshair.HOLDING_BLOCK;
                            case ItemCategory.SHIELD -> Crosshair.SHIELD;
                            case ItemCategory.USABLE -> Crosshair.USABLE;
                            default -> null;
                        })) == null) continue;
                        break;
                    }
                    catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                        if (e instanceof CrosshairContextChange) {
                            throw e;
                        }
                        LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                    }
                }
                if (crosshair == null) {
                    context.setHand(InteractionHand.OFF_HAND);
                    for (DynamicCrosshairApi api : context.apis()) {
                        if ((crosshair = (switch (api.getItemCategory(context.getItemStack())) {
                            case ItemCategory.RANGED_WEAPON -> Crosshair.RANGED_WEAPON;
                            case ItemCategory.THROWABLE -> Crosshair.THROWABLE;
                            case ItemCategory.BLOCK -> Crosshair.HOLDING_BLOCK;
                            case ItemCategory.SHIELD -> Crosshair.SHIELD;
                            case ItemCategory.USABLE -> Crosshair.USABLE;
                            default -> null;
                        })) == null) continue;
                        break;
                    }
                    context.setHand(InteractionHand.MAIN_HAND);
                }
                if (!context.isWithEntity()) break block30;
                Entity entity = context.getEntity();
                for (DynamicCrosshairApi api : context.apis()) {
                    try {
                        if (!api.isAlwaysInteractableEntity(entity) && !api.isInteractableEntity(entity)) continue;
                        return Crosshair.combine(Crosshair.INTERACTABLE, crosshair);
                    }
                    catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                        if (e instanceof CrosshairContextChange) {
                            throw e;
                        }
                        LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                    }
                }
                break block31;
            }
            if (!context.isWithBlock()) break block31;
            BlockState blockState = context.getBlockState();
            for (DynamicCrosshairApi api : context.apis()) {
                try {
                    if (!api.isAlwaysInteractableBlock(blockState) && !api.isInteractableBlock(blockState)) continue;
                    return Crosshair.combine(Crosshair.INTERACTABLE, crosshair);
                }
                catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                    if (e instanceof CrosshairContextChange) {
                        throw e;
                    }
                    LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                }
            }
        }
        return crosshair;
    }

    private static Crosshair buildCrosshairDynamic(CrosshairContext context) {
        if (DynamicCrosshair.config.isDynamicCrosshairSimple()) {
            return CrosshairHandler.buildCrosshairSimple(context);
        }
        return CrosshairHandler.buildCrosshairAdvanced(context);
    }

    private static void debug(List<DynamicCrosshairApi> apis, Function<DynamicCrosshairApi, Object> callback) {
        for (DynamicCrosshairApi api : apis) {
            try {
                LOGGER.info("  {}:{}: {}", new Object[]{api.getNamespace(), api.getModId(), callback.apply(api)});
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                if (e instanceof CrosshairContextChange) {
                    throw e;
                }
                LOGGER.info("  {}:{}: FAILED", (Object)api.getNamespace(), (Object)api.getModId());
            }
        }
    }

    public static void debug() {
        CrosshairContext context = CrosshairHandler.state.context;
        List<DynamicCrosshairApi> apis = context.apis();
        LOGGER.info("Dynamic Crosshair evaluation");
        LOGGER.info("Context:");
        LOGGER.info("  Main hand:{}", (Object)context.getItemStack(InteractionHand.MAIN_HAND));
        LOGGER.info("  Offhand:{}", (Object)context.getItemStack(InteractionHand.OFF_HAND));
        LOGGER.info("  Block:{}", context.isWithBlock() ? context.getBlockState() : "null");
        LOGGER.info("  Entity:{}", context.isWithEntity() ? context.getEntity() : "null");
        LOGGER.info("Active APIs: " + String.valueOf(apis.stream().map(api -> api.getNamespace() + ":" + api.getModId()).toList()));
        LOGGER.info("Forcing invalidation: {}", apis.stream().filter(api -> api.forceInvalidate(context)).collect(Collectors.toList()));
        LOGGER.info(".getItemCategory(MAIN_HAND)");
        CrosshairHandler.debug(apis, api -> api.getItemCategory(context.getItemStack()));
        LOGGER.info(".isAlwaysUsableItem(MAIN_HAND)");
        CrosshairHandler.debug(apis, api -> api.isAlwaysUsableItem(context.getItemStack()));
        LOGGER.info(".isUsableItem(MAIN_HAND)");
        CrosshairHandler.debug(apis, api -> api.isUsableItem(context.getItemStack()));
        LOGGER.info(".computeFromItem(MAIN_HAND)");
        CrosshairHandler.debug(apis, api -> api.computeFromItem(context));
        context.setHand(InteractionHand.OFF_HAND);
        LOGGER.info(".getItemCategory(OFF_HAND)");
        CrosshairHandler.debug(apis, api -> api.getItemCategory(context.getItemStack()));
        LOGGER.info(".isAlwaysUsableItem(OFF_HAND)");
        CrosshairHandler.debug(apis, api -> api.isAlwaysUsableItem(context.getItemStack()));
        LOGGER.info(".isUsableItem(OFF_HAND)");
        CrosshairHandler.debug(apis, api -> api.isUsableItem(context.getItemStack()));
        LOGGER.info(".computeFromItem(OFF_HAND)");
        CrosshairHandler.debug(apis, api -> api.computeFromItem(context));
        context.setHand(InteractionHand.MAIN_HAND);
        if (context.isWithEntity()) {
            LOGGER.info(".isAlwaysInteractableEntity()");
            CrosshairHandler.debug(apis, api -> api.isAlwaysInteractableEntity(context.getEntity()));
            LOGGER.info(".isInteractableEntity()");
            CrosshairHandler.debug(apis, api -> api.isInteractableEntity(context.getEntity()));
            LOGGER.info(".computeFromEntity(MAIN_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromEntity(context));
            context.setHand(InteractionHand.OFF_HAND);
            LOGGER.info(".computeFromEntity(OFF_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromEntity(context));
            context.setHand(InteractionHand.MAIN_HAND);
        }
        if (context.isWithBlock()) {
            LOGGER.info(".isAlwaysInteractableBlock()");
            CrosshairHandler.debug(apis, api -> api.isAlwaysInteractableBlock(context.getBlockState()));
            LOGGER.info(".isInteractableBlock()");
            CrosshairHandler.debug(apis, api -> api.isInteractableBlock(context.getBlockState()));
            LOGGER.info(".computeFromBlock(MAIN_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromBlock(context));
            context.setHand(InteractionHand.OFF_HAND);
            LOGGER.info(".computeFromBlock(OFF_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromBlock(context));
            context.setHand(InteractionHand.MAIN_HAND);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Boolean> buildCrosshair(HitResult hitResult, LocalPlayer player) {
        try {
            for (DynamicCrosshairApi api : CrosshairHandler.state.context.apis()) {
                try {
                    hitResult = api.overrideHitResult(CrosshairHandler.state.context, hitResult);
                }
                catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                    if (e instanceof CrosshairContextChange) {
                        throw e;
                    }
                    LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), e);
                }
            }
            if (!state.changed(hitResult, player)) {
                return Optional.of(shouldShowCrosshair);
            }
            activeCrosshair = new Crosshair();
            switch (hitResult.m_6662_()) {
                case ENTITY: {
                    if (!DynamicCrosshair.config.dynamicCrosshairOnEntity()) break;
                    activeCrosshair.setVariant(CrosshairVariant.OnEntity);
                    break;
                }
                case BLOCK: {
                    switch (DynamicCrosshair.config.dynamicCrosshairOnBlock()) {
                        case IfTargeting: {
                            activeCrosshair.setVariant(CrosshairVariant.OnBlock);
                            break;
                        }
                        case IfInteractable: {
                            if (!CrosshairHandler.isBlockInteractable(CrosshairHandler.state.context)) break;
                            activeCrosshair.setVariant(CrosshairVariant.OnBlock);
                        }
                    }
                    break;
                }
            }
            if (!activeCrosshair.updateFrom(CrosshairHandler.buildCrosshairDynamic(CrosshairHandler.state.context))) return Optional.empty();
            return Optional.of(true);
        }
        catch (CrosshairContextChange crosshairContextChange) {
            return CrosshairHandler.buildCrosshair(crosshairContextChange.newHitResult, player);
        }
        catch (InvalidContextState invalidContextState) {
            LOGGER.error("Encountered invalid context state: ", (Throwable)invalidContextState);
            return Optional.empty();
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
            LOGGER.error("Encountered an unexpected error. This usually is due to outdated mod support." + String.valueOf(e));
        }
        return Optional.empty();
    }

    private static boolean checkShowCrosshair() {
        Optional<Boolean> result;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || state != null && CrosshairHandler.state.context.player != player) {
            state = null;
            return false;
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null) {
            state = null;
            return false;
        }
        if (DynamicCrosshair.config.isHideWithScreen() && Minecraft.m_91087_().f_91080_ != null) {
            state = null;
            return false;
        }
        if (DynamicCrosshair.config.isHideWithMap() && player.m_21205_().m_41720_() instanceof MapItem && player.m_21206_().m_41619_()) {
            state = null;
            return false;
        }
        if (state == null) {
            state = new State();
        }
        if ((result = CrosshairHandler.buildCrosshair(hitResult, player)).isPresent()) {
            return result.get();
        }
        if (activeCrosshair.isChanged()) {
            return true;
        }
        if (DynamicCrosshair.config.isDynamicCrosshair()) {
            return false;
        }
        activeCrosshair.setVariant(CrosshairVariant.Regular);
        return true;
    }

    public static boolean shouldShowCrosshair() {
        return shouldShowCrosshair;
    }

    public static void tick() {
        shouldShowCrosshair = CrosshairHandler.checkShowCrosshair();
    }
}

