/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    HitState previousState;
    HitStateFluid previousFluidState = null;
    public final CrosshairContext context = new CrosshairContext();

    public boolean changed(HitResult hitResult, LocalPlayer player) {
        HitState newState;
        switch (hitResult.m_6662_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLOCK: {
                HitState hitState = new HitStateBlock(player, (BlockHitResult)hitResult);
                break;
            }
            case ENTITY: {
                HitState hitState = new HitStateEntity(player, (EntityHitResult)hitResult);
                break;
            }
            case MISS: {
                HitState hitState = newState = new HitStateMiss(player, hitResult);
            }
        }
        if (this.previousState == null) {
            this.previousState = newState;
            return true;
        }
        for (DynamicCrosshairApi api : this.context.apis()) {
            try {
                if (!api.forceInvalidate(this.context)) continue;
                this.previousState = newState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.error("Exception occurred during evaluation of API " + api.getModId(), (Throwable)e);
            }
        }
        if (newState.isChanged(this.previousState)) {
            this.previousState = newState;
            if (this.previousFluidState != null) {
                this.previousFluidState = null;
                this.context.invalidateHitResult(hitResult);
            }
            return true;
        }
        if (!player.m_21211_().m_41619_()) {
            return true;
        }
        BlockHitResult fluidHitResult = this.context.raycastWithFluid();
        if (fluidHitResult.m_6662_() == HitResult.Type.BLOCK) {
            HitStateFluid newFluidState = new HitStateFluid(fluidHitResult);
            if (newFluidState.isChanged(this.previousFluidState)) {
                this.previousFluidState = newFluidState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
        } else if (this.previousFluidState != null) {
            this.previousFluidState = null;
            this.context.invalidateHitResult(hitResult);
            return true;
        }
        return false;
    }

    private static class HitStateFluid {
        final int level;
        final Fluid fluid;

        public HitStateFluid(BlockHitResult fluidHitResult) {
            FluidState fluidState = Minecraft.m_91087_().f_91073_.m_6425_(fluidHitResult.m_82425_());
            this.fluid = fluidState.m_76152_();
            this.level = this.fluid.m_7430_(fluidState);
        }

        public boolean isChanged(HitStateFluid other) {
            return other == null || this.fluid != other.fluid || this.level != other.level;
        }
    }

    private class HitStateBlock
    extends HitState {
        final int x;
        final int y;
        final int z;
        final Direction side;
        final BlockState blockState;

        public HitStateBlock(LocalPlayer player, BlockHitResult blockHitResult) {
            super(player, (HitResult)blockHitResult);
            BlockPos blockPos = blockHitResult.m_82425_();
            this.x = blockPos.m_123341_();
            this.y = blockPos.m_123342_();
            this.z = blockPos.m_123343_();
            this.side = blockHitResult.m_82434_();
            this.blockState = Minecraft.m_91087_().f_91073_.m_8055_(blockPos);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateBlock) {
                HitStateBlock otherBlock = (HitStateBlock)other;
                if (this.x == otherBlock.x && this.y == otherBlock.y && this.z == otherBlock.z && this.side == otherBlock.side && this.blockState == otherBlock.blockState) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateEntity
    extends HitState {
        final Entity entity;

        public HitStateEntity(LocalPlayer player, EntityHitResult entityHitResult) {
            super(player, (HitResult)entityHitResult);
            this.entity = entityHitResult.m_82443_();
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateEntity) {
                HitStateEntity otherEntity = (HitStateEntity)other;
                if (this.entity == otherEntity.entity) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateMiss
    extends HitState {
        public HitStateMiss(LocalPlayer player, HitResult hitResult) {
            super(player, hitResult);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateMiss) {
                return false;
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitState {
        final HitResult hitResult;
        final ItemStack mainHandStack;
        final ItemStack offHandStack;
        final ItemStack activeStack;
        final InteractionHand activeHand;
        final boolean cancelInteraction;
        final boolean isCoolingDown;
        final boolean isOnGround;
        final boolean isFallFlying;

        public HitState(LocalPlayer player, HitResult hitResult) {
            this.hitResult = hitResult;
            this.mainHandStack = player.m_21205_().m_41777_();
            this.offHandStack = player.m_21206_().m_41777_();
            this.activeStack = player.m_21211_().m_41777_();
            this.activeHand = player.m_7655_();
            this.cancelInteraction = player.m_36341_();
            this.isCoolingDown = player.m_36335_().m_41519_(this.mainHandStack.m_41720_()) || player.m_36335_().m_41519_(this.offHandStack.m_41720_());
            this.isOnGround = player.m_20096_();
            this.isFallFlying = player.m_21255_();
        }

        public boolean isChanged(HitState other) {
            boolean invalidated = false;
            if (!ItemStack.m_41728_((ItemStack)this.mainHandStack, (ItemStack)other.mainHandStack)) {
                State.this.context.invalidateItem(InteractionHand.MAIN_HAND);
                invalidated = true;
            }
            if (!ItemStack.m_41728_((ItemStack)this.offHandStack, (ItemStack)other.offHandStack)) {
                State.this.context.invalidateItem(InteractionHand.OFF_HAND);
                invalidated = true;
            }
            if (!ItemStack.m_41728_((ItemStack)this.activeStack, (ItemStack)other.activeStack)) {
                State.this.context.invalidateItem(this.activeHand);
                invalidated = true;
            }
            return invalidated || this.cancelInteraction != other.cancelInteraction || this.isCoolingDown != other.isCoolingDown || this.isOnGround != other.isOnGround || this.isFallFlying != other.isFallFlying;
        }
    }
}

