/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import java.util.List;
import java.util.Optional;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.ModifierUse;
import mod.crend.dynamiccrosshair.mixin.ChiseledBookshelfBlockAccessor;
import mod.crend.dynamiccrosshair.mixin.DoorBlockAccessor;
import mod.crend.dynamiccrosshair.mixin.FlowerPotBlockAccessor;
import mod.crend.dynamiccrosshair.mixin.RedstoneWireBlockAccessor;
import mod.crend.dynamiccrosshair.mixin.TrapdoorBlockAccessor;
import mod.crend.yaclx.type.BlockOrTag;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FletchingTableBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;

public class VanillaBlockHandler {
    public static Crosshair checkToolWithBlock(CrosshairContext context) {
        Item handItem = context.getItem();
        BlockPos blockPos = context.getBlockPos();
        BlockState blockState = context.getBlockState();
        if (blockState == null) {
            return null;
        }
        if (handItem instanceof DiggerItem) {
            if (handItem.m_8096_(blockState) && handItem.m_6777_(blockState, (Level)context.world, blockPos, (Player)context.player)) {
                return Crosshair.CORRECT_TOOL;
            }
            return Crosshair.INCORRECT_TOOL;
        }
        if (handItem.m_8102_(context.getItemStack(), blockState) > 1.0f && handItem.m_6777_(blockState, (Level)context.world, blockPos, (Player)context.player)) {
            return Crosshair.CORRECT_TOOL;
        }
        if (handItem instanceof ShearsItem) {
            return Crosshair.INCORRECT_TOOL;
        }
        return null;
    }

    public static boolean isAlwaysInteractableBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block instanceof AbstractChestBlock || block instanceof AbstractFurnaceBlock || block instanceof BarrelBlock || block instanceof BeaconBlock || block instanceof BellBlock || block instanceof BrewingStandBlock || block instanceof DaylightDetectorBlock || block instanceof DispenserBlock || block instanceof EnchantmentTableBlock || block instanceof HopperBlock || block instanceof ShulkerBoxBlock || block instanceof StonecutterBlock || block instanceof GrindstoneBlock || block instanceof CartographyTableBlock || block instanceof LoomBlock || block instanceof BedBlock || block instanceof TrapDoorBlock && ((TrapdoorBlockAccessor)block).getBlockSetType().f_278463_() || block instanceof DoorBlock && ((DoorBlockAccessor)block).getBlockSetType().f_278463_() || block instanceof FenceGateBlock || block instanceof ButtonBlock || block instanceof NoteBlock || block instanceof LeverBlock || block instanceof DiodeBlock || block instanceof AnvilBlock || block instanceof CraftingTableBlock && !(block instanceof FletchingTableBlock) || BlockOrTag.isContainedIn((Block)block, DynamicCrosshair.config.getAdditionalInteractableBlocks());
    }

    public static boolean isInteractableBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block instanceof CommandBlock || block instanceof JukeboxBlock || block instanceof LecternBlock || block instanceof ComposterBlock || block instanceof FlowerPotBlock || block instanceof CakeBlock || block instanceof SweetBerryBushBlock || block instanceof AbstractCandleBlock || block instanceof CampfireBlock || block instanceof ChiseledBookShelfBlock;
    }

    public static Crosshair checkBlockInteractable(CrosshairContext context) {
        Optional<Vec2> hitPos;
        CampfireBlockEntity campfire;
        Item mainItem;
        Item handItem;
        BlockEntity potItemIsAir2;
        BlockState blockState = context.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof CommandBlock && context.player.m_7500_() || block instanceof JukeboxBlock && (Boolean)blockState.m_61143_((Property)JukeboxBlock.f_54254_) != false || block instanceof LecternBlock && (Boolean)blockState.m_61143_((Property)LecternBlock.f_54467_) != false || block instanceof ComposterBlock && ComposterBlock.f_51914_.containsKey((Object)context.getItem())) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof FlowerPotBlock) {
            boolean handItemIsPottable;
            Item handItem2 = context.getItem();
            boolean potItemIsAir2 = ((FlowerPotBlock)block).m_53560_() == Blocks.f_50016_;
            boolean bl = handItemIsPottable = handItem2 instanceof BlockItem && FlowerPotBlockAccessor.getCONTENT_TO_POTTED().containsKey(((BlockItem)handItem2).m_40614_());
            if (potItemIsAir2 && handItemIsPottable) {
                return Crosshair.USABLE;
            }
            if (!potItemIsAir2 && !handItemIsPottable) {
                return Crosshair.INTERACTABLE.withFlag(Crosshair.Flag.FixedStyle);
            }
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedStyle, Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof SignBlock && (potItemIsAir2 = context.getBlockEntity()) instanceof SignBlockEntity) {
            SignBlockEntity signBlockEntity = (SignBlockEntity)potItemIsAir2;
            handItem = context.getItem();
            SignText signText = signBlockEntity.m_277176_((Player)context.player);
            if (signBlockEntity.m_277118_()) {
                if (signText.m_276807_((Player)context.player)) {
                    return Crosshair.INTERACTABLE;
                }
                return Crosshair.NONE.withFlag(Crosshair.Flag.FixedStyle, Crosshair.Flag.FixedModifierUse);
            }
            if (handItem instanceof SignApplicator) {
                if (signText.m_276776_((Player)context.player)) {
                    if (handItem.equals(Items.f_151056_) && !signText.m_276843_()) {
                        return Crosshair.USABLE;
                    }
                    if (handItem.equals(Items.f_42532_) && signText.m_276843_()) {
                        return Crosshair.USABLE;
                    }
                    if (handItem instanceof DyeItem) {
                        DyeItem dye = (DyeItem)handItem;
                        if (signText.m_276773_() != dye.m_41089_()) {
                            return Crosshair.USABLE;
                        }
                    }
                }
                if (handItem.equals(Items.f_42784_)) {
                    return Crosshair.USABLE;
                }
            }
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof CakeBlock && context.player.m_36391_(false) && context.shouldInteract()) {
            return Crosshair.USABLE;
        }
        if (block instanceof SweetBerryBushBlock && (Integer)blockState.m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1) {
            return Crosshair.USABLE;
        }
        if (block instanceof CaveVines && CaveVines.m_152951_((BlockState)blockState)) {
            return Crosshair.USABLE;
        }
        if (block instanceof RedStoneOreBlock && context.shouldInteract()) {
            return new Crosshair(ModifierUse.USE_ITEM).withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (!(!(block instanceof AbstractCandleBlock) || !((Boolean)blockState.m_61143_((Property)AbstractCandleBlock.f_151895_)).booleanValue() || (mainItem = context.getItem()).equals(Items.f_42409_) || mainItem instanceof BlockItem || mainItem instanceof SpawnEggItem || mainItem instanceof FireChargeItem || mainItem instanceof EnderEyeItem || mainItem instanceof EnderpearlItem || mainItem instanceof WritableBookItem || mainItem instanceof WrittenBookItem || mainItem instanceof PotionItem || mainItem.m_6164_(context.getItemStack()) == UseAnim.DRINK || mainItem.m_6164_(context.getItemStack()) == UseAnim.EAT && context.player.m_36391_(false))) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof LecternBlock) {
            Item handItem3 = context.getItem();
            if (handItem3.equals(Items.f_42615_) || handItem3.equals(Items.f_42614_) || !context.player.m_36341_() && ((Boolean)blockState.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
                return Crosshair.USABLE;
            }
            return Crosshair.NONE.withFlag(Crosshair.Flag.FixedModifierUse);
        }
        if (block instanceof CampfireBlock && (handItem = context.getBlockEntity()) instanceof CampfireBlockEntity && (campfire = (CampfireBlockEntity)handItem).m_59051_(context.getItemStack()).isPresent()) {
            return Crosshair.USABLE;
        }
        if (block instanceof RedStoneWireBlock && (RedstoneWireBlockAccessor.invokeIsFullyConnected(blockState) || RedstoneWireBlockAccessor.invokeIsNotConnected(blockState))) {
            return Crosshair.INTERACTABLE;
        }
        if (block instanceof ChiseledBookShelfBlock && (hitPos = ChiseledBookshelfBlockAccessor.invokeGetHitPos(context.getBlockHitResult(), (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).isPresent()) {
            int i = ChiseledBookshelfBlockAccessor.invokeGetSlotForHitPos(hitPos.get());
            if (((Boolean)blockState.m_61143_((Property)ChiseledBookShelfBlock.f_260698_.get(i))).booleanValue()) {
                return Crosshair.INTERACTABLE;
            }
            if (context.getItemStack().m_204117_(ItemTags.f_244646_)) {
                return Crosshair.USABLE;
            }
        }
        if (blockState.m_204336_(BlockTags.f_13039_)) {
            BlockPos pos = context.getBlockPos();
            List list = context.world.m_45976_(Mob.class, new AABB((double)pos.m_123341_() - 7.0, (double)pos.m_123342_() - 7.0, (double)pos.m_123343_() - 7.0, (double)pos.m_123341_() + 7.0, (double)pos.m_123342_() + 7.0, (double)pos.m_123343_() + 7.0));
            for (Mob mob : list) {
                if (mob.m_21524_() != context.player) continue;
                return Crosshair.USABLE;
            }
        }
        return null;
    }
}

