/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import mod.crend.dynamiccrosshair.PlatformUtils;
import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.mixin.ArmorStandEntityAccessor;
import mod.crend.dynamiccrosshair.mixin.BoatEntityAccessor;
import mod.crend.dynamiccrosshair.mixin.FurnaceMinecartEntityAccessor;
import mod.crend.dynamiccrosshair.mixin.ParrotEntityAccessor;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class VanillaEntityHandler {
    public static boolean isEntityInteractable(Entity entity) {
        return entity instanceof ItemFrame || entity instanceof Boat || entity instanceof AbstractMinecart || entity.m_6095_() == EntityType.f_20553_ || entity.m_6095_() == EntityType.f_20499_ || entity instanceof Parrot || entity instanceof AbstractHorse || entity instanceof AbstractVillager || entity instanceof Allay;
    }

    public static Crosshair checkEntity(CrosshairContext context) {
        Item handItem = context.getItem();
        Entity entity = context.getEntity();
        if (entity instanceof Animal && ((Animal)entity).m_6898_(context.getItemStack())) {
            return Crosshair.USABLE;
        }
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            if (handItem instanceof SpawnEggItem) {
                return Crosshair.USABLE;
            }
            if (handItem == Items.f_42655_) {
                if (mobEntity.m_6573_((Player)context.player)) {
                    return Crosshair.USABLE;
                }
                return null;
            }
        }
        if (entity instanceof Shearable) {
            Shearable shearableEntity = (Shearable)entity;
            if (handItem == Items.f_42574_) {
                if (shearableEntity.m_6220_()) {
                    return Crosshair.USABLE;
                }
                return null;
            }
        }
        if (entity == null) {
            return null;
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (context.isMainHand() || context.getItemStack(InteractionHand.MAIN_HAND).m_150930_(Items.f_42656_)) {
                EquipmentSlot slot;
                ItemStack itemStack = context.getItemStack();
                if (itemStack.m_41619_()) {
                    Vec3 hitPos = context.hitResult.m_82450_().m_82546_(armorStand.m_20182_());
                    EquipmentSlot slot2 = ((ArmorStandEntityAccessor)armorStand).invokeGetSlotFromPosition(hitPos);
                    if (armorStand.m_21033_(slot2)) {
                        return Crosshair.INTERACTABLE;
                    }
                } else if (itemStack.m_150930_(Items.f_42656_) ? itemStack.m_41788_() : !(((ArmorStandEntityAccessor)armorStand).invokeIsSlotDisabled(slot = Mob.m_147233_((ItemStack)itemStack)) || slot.m_20743_() == EquipmentSlot.Type.HAND && !armorStand.m_31671_() || armorStand.m_21033_(slot) && itemStack.m_41613_() != 1)) {
                    return Crosshair.USABLE;
                }
            }
        } else {
            if (entity instanceof Bucketable) {
                BucketItem bucketItem;
                if (handItem instanceof BucketItem && PlatformUtils.getFluidFromBucket(bucketItem = (BucketItem)handItem) == Fluids.f_76193_) {
                    return Crosshair.USABLE;
                }
                return null;
            }
            if (entity instanceof Boat) {
                Boat boatEntity = (Boat)entity;
                if (entity instanceof ContainerEntity) {
                    return Crosshair.INTERACTABLE;
                }
                if (!context.player.m_36341_() && ((BoatEntityAccessor)boatEntity).invokeCanAddPassenger((Entity)context.player)) {
                    return Crosshair.INTERACTABLE;
                }
            } else if (entity instanceof AbstractMinecart) {
                AbstractMinecart minecartEntity = (AbstractMinecart)entity;
                if (entity.m_6095_() == EntityType.f_20469_ && !minecartEntity.m_20160_() || entity instanceof AbstractMinecartContainer || entity.m_6095_() == EntityType.f_20472_ && FurnaceMinecartEntityAccessor.getACCEPTABLE_FUEL().test(context.getItemStack())) {
                    return Crosshair.INTERACTABLE;
                }
            } else {
                if (entity.m_6095_() == EntityType.f_20553_ || entity.m_6095_() == EntityType.f_20499_) {
                    TamableAnimal pet = (TamableAnimal)entity;
                    if (pet.m_21824_() && pet.m_21830_((LivingEntity)context.player)) {
                        return Crosshair.INTERACTABLE;
                    }
                    return null;
                }
                if (entity.m_6095_() == EntityType.f_20557_ || entity.m_6095_() == EntityType.f_147035_) {
                    if (handItem == Items.f_42446_ && !((Animal)entity).m_6162_()) {
                        return Crosshair.USABLE;
                    }
                    return null;
                }
                if (entity.m_6095_() == EntityType.f_20558_) {
                    if (handItem == Items.f_42409_) {
                        return Crosshair.USABLE;
                    }
                    return null;
                }
                if (entity.m_6095_() == EntityType.f_20559_) {
                    if (context.getItemStack().m_204117_(ItemTags.f_13156_)) {
                        return Crosshair.USABLE;
                    }
                    return null;
                }
                if (entity instanceof AbstractChestedHorse || entity instanceof Horse) {
                    AbstractChestedHorse donkey;
                    AbstractHorse horse = (AbstractHorse)entity;
                    if (horse.m_6162_() || !horse.m_30614_()) {
                        return null;
                    }
                    if (horse.m_30614_() && context.player.m_36341_()) {
                        return Crosshair.INTERACTABLE;
                    }
                    if (entity instanceof AbstractChestedHorse && !(donkey = (AbstractChestedHorse)entity).m_30502_() && context.getItemStack().m_150930_(Blocks.f_50087_.m_5456_())) {
                        return Crosshair.USABLE;
                    }
                    if (horse.m_6741_() && !horse.m_6254_() && handItem == Items.f_42450_) {
                        return Crosshair.USABLE;
                    }
                    return Crosshair.INTERACTABLE;
                }
                if (entity.m_6095_() == EntityType.f_20460_) {
                    if (handItem == Items.f_42416_ && ((LivingEntity)entity).m_21223_() < ((LivingEntity)entity).m_21233_()) {
                        return Crosshair.USABLE;
                    }
                    return null;
                }
                if (entity instanceof ItemFrame) {
                    ItemFrame itemFrame = (ItemFrame)entity;
                    if (itemFrame.m_31822_().m_41619_()) {
                        if (context.getItemStack().m_41619_()) {
                            return null;
                        }
                        return Crosshair.USABLE;
                    }
                    return Crosshair.INTERACTABLE;
                }
                if (entity.m_6095_() == EntityType.f_20464_) {
                    return Crosshair.USABLE;
                }
                if (entity.m_6095_() == EntityType.f_20507_) {
                    if (((Panda)entity).m_29151_()) {
                        return Crosshair.INTERACTABLE;
                    }
                    return null;
                }
                if (entity instanceof Parrot) {
                    Parrot parrot = (Parrot)entity;
                    if (!parrot.m_21824_() && ParrotEntityAccessor.getTAMING_INGREDIENTS().contains(handItem)) {
                        return Crosshair.USABLE;
                    }
                    if (handItem == Items.f_42572_) {
                        return Crosshair.USABLE;
                    }
                    if (!parrot.m_29443_() && parrot.m_21824_() && parrot.m_21830_((LivingEntity)context.player)) {
                        return Crosshair.INTERACTABLE;
                    }
                } else {
                    if (entity instanceof AbstractVillager) {
                        AbstractVillager merchant = (AbstractVillager)entity;
                        if (!(merchant.m_35306_() || merchant.m_5803_() || merchant.m_6616_().isEmpty())) {
                            return Crosshair.INTERACTABLE;
                        }
                        return null;
                    }
                    if (entity.m_6095_() == EntityType.f_20530_) {
                        if (handItem == Items.f_42436_ && ((LivingEntity)entity).m_21023_(MobEffects.f_19613_)) {
                            return Crosshair.USABLE;
                        }
                        return null;
                    }
                    if (entity instanceof Allay) {
                        Allay allay = (Allay)entity;
                        ItemStack allayItemStack = allay.m_21120_(InteractionHand.MAIN_HAND);
                        ItemStack handItemStack = context.getItemStack();
                        if (allayItemStack.m_41619_() && !handItemStack.m_41619_()) {
                            return Crosshair.USABLE;
                        }
                        if (!allayItemStack.m_41619_() && context.isMainHand() && handItemStack.m_41619_()) {
                            return Crosshair.INTERACTABLE;
                        }
                    }
                }
            }
        }
        return null;
    }
}

