/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;

public class ModularWorkBench
extends BaseEntityBlock {
    private static final VoxelShape BOTTOM = Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0);
    private static final VoxelShape CONNECTOR = Block.m_49796_((double)3.0, (double)4.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0);
    private static final VoxelShape BASE = Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)CONNECTOR);
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WHOLE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)TOP);
    private static final VoxelShape BOTTOM_SWAPPED = Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0);
    private static final VoxelShape CONNECTOR_SWAPPED = Block.m_49796_((double)5.0, (double)4.0, (double)3.0, (double)11.0, (double)12.0, (double)13.0);
    private static final VoxelShape BASE_SWAPPED = Shapes.m_83110_((VoxelShape)BOTTOM_SWAPPED, (VoxelShape)CONNECTOR_SWAPPED);
    private static final VoxelShape TOP_SWAPPED = Block.m_49796_((double)2.0, (double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape WHOLE_SWAPPED = Shapes.m_83110_((VoxelShape)BASE_SWAPPED, (VoxelShape)TOP_SWAPPED);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ModularWorkBench(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_6724_(BlockState state) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
            return WHOLE;
        }
        return WHOLE_SWAPPED;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(world, pos));
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        ModularWorkBenchEntity be;
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ModularWorkBenchEntity && !(be = (ModularWorkBenchEntity)blockEntity).getItem().m_41619_()) {
            Vec3 vec = pos.m_252807_();
            Containers.m_18992_((Level)world, (double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_, (ItemStack)be.getItem());
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ModularWorkBenchEntity) {
            ModularWorkBenchEntity be = (ModularWorkBenchEntity)blockEntity;
            return be;
        }
        return null;
    }

    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel world, T blockEntity) {
        if (blockEntity instanceof ModularWorkBenchEntity) {
            ModularWorkBenchEntity bench = (ModularWorkBenchEntity)blockEntity;
            return bench;
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ModularWorkBenchEntity(pos, state);
    }
}

