/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.util.MiscUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.IStatProvidingBlock;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

public class ModularWorkBenchEntity
extends BlockEntity
implements MenuProvider,
GameEventListener {
    public static final Map<GameEvent, CustomGameEventHandler> gameEventHandlers = (Map)MiscUtil.initialize(new ConcurrentHashMap(), map -> {
        map.put(RegistryInventory.statProviderCreatedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.f_223712_() != null) {
                BlockPos pos = new BlockPos((int)emitterPos.f_82479_, (int)emitterPos.f_82480_, (int)emitterPos.f_82481_);
                Block block = emitter.f_223712_().m_60734_();
                if (block instanceof IStatProvidingBlock) {
                    IStatProvidingBlock statProvider = (IStatProvidingBlock)block;
                    bench.persistentStats.computeIfAbsent(pos.toString(), s -> new StatProvidersMap());
                    bench.persistentStats.get(pos.toString()).putAll(statProvider.getProviders(bench, emitter.f_223712_(), pos, world));
                }
            }
            return false;
        });
        map.put(RegistryInventory.statProviderRemovedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.f_223712_() != null) {
                BlockPos pos = new BlockPos((int)emitterPos.f_82479_, (int)emitterPos.f_82480_, (int)emitterPos.f_82481_);
                bench.persistentStats.remove(pos.toString());
            }
            return false;
        });
    });
    protected final ContainerData propertyDelegate;
    private ItemStack stack;
    public final Map<String, StatProvidersMap> persistentStats = new HashMap<String, StatProvidersMap>();
    protected final Map<CraftingStat, Object> stats = new HashMap<CraftingStat, Object>();
    public int x;
    public int y;
    public int z;
    protected BlockPositionSource blockPositionSource;
    List<WeakReference<CraftingScreenHandler>> handlers = new ArrayList<WeakReference<CraftingScreenHandler>>();

    public ModularWorkBenchEntity(BlockPos pos, BlockState state) {
        super(RegistryInventory.modularWorkBenchEntityType, pos, state);
        this.stack = ItemStack.f_41583_;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> 1;
                    case 1 -> (short)(ModularWorkBenchEntity.this.x >> 16);
                    case 2 -> (short)ModularWorkBenchEntity.this.x;
                    case 3 -> (short)(ModularWorkBenchEntity.this.y >> 16);
                    case 4 -> (short)ModularWorkBenchEntity.this.y;
                    case 5 -> (short)(ModularWorkBenchEntity.this.z >> 16);
                    case 6 -> (short)ModularWorkBenchEntity.this.z;
                    default -> -1;
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 7;
            }
        };
        this.m_6596_();
    }

    public void setItem(ItemStack stack) {
        this.stack = stack == null ? ItemStack.f_41583_ : stack.m_41777_();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public <T> T getStat(CraftingStat<T> stat) {
        return (T)this.stats.get(stat);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Item", (Tag)this.stack.m_41739_(new CompoundTag()));
        CompoundTag persisStatsNbt = new CompoundTag();
        this.persistentStats.forEach((key, val) -> persisStatsNbt.m_128365_(key, (Tag)StatProvidersMap.MODULELESS_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, val).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to encode persistent StatProvidersMap for MWBE! -> {}", s))));
        CompoundTag statsNbt = new CompoundTag();
        this.stats.forEach((stat, inst) -> statsNbt.m_128365_(RegistryInventory.craftingStats.findKey((CraftingStat)stat), stat.saveToNbt(inst)));
        tag.m_128365_("PersistentStats", (Tag)persisStatsNbt);
        tag.m_128365_("Stats", (Tag)statsNbt);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.persistentStats.clear();
        this.stats.clear();
        if (tag.m_128441_("Item")) {
            this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        }
        CompoundTag persisStatsNbt = tag.m_128469_("PersistentStats");
        persisStatsNbt.m_128431_().forEach(key -> this.persistentStats.put((String)key, (StatProvidersMap)MiscCodecs.quickParse((DynamicOps)NbtOps.f_128958_, (Object)persisStatsNbt.m_128469_(key), (Codec)StatProvidersMap.MODULELESS_CODEC, s -> Miapi.LOGGER.error("Failed to decode persistent StatProvidersMap for MWBE! -> {}", s))));
        CompoundTag statsNbt = tag.m_128469_("Stats");
        statsNbt.m_128431_().forEach(key -> {
            CraftingStat stat = RegistryInventory.craftingStats.get((String)key);
            if (stat == null) {
                Miapi.LOGGER.warn("Found unknown CraftingStat id '{}'!", key);
                return;
            }
            this.stats.put(stat, stat.createFromNbt(statsNbt.m_128423_(key)));
        });
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> be.m_187482_());
    }

    public void saveAndSync() {
        this.m_6596_();
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.m_58900_(), 3);
        }
        this.handlers.forEach(weakReference -> {
            CraftingScreenHandler handler = (CraftingScreenHandler)((Object)((Object)weakReference.get()));
            if (handler != null && !ItemStack.m_41728_((ItemStack)handler.inventory.m_8020_(0), (ItemStack)this.getItem())) {
                handler.inventory.m_6836_(0, this.getItem());
            }
        });
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"test");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        CraftingScreenHandler handler = new CraftingScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
        this.stats.clear();
        StatProvidersMap providers = new StatProvidersMap();
        ((MiapiEvents.StatUpdateEvent)MiapiEvents.STAT_UPDATE_EVENT.invoker()).update(this, providers, syncId, playerInventory, player, handler);
        this.persistentStats.forEach((key, map) -> providers.putAll((StatProvidersMap)map));
        this.stats.putAll(providers.evaluateAll());
        this.saveAndSync();
        this.handlers.add(new WeakReference<CraftingScreenHandler>(handler));
        return handler;
    }

    public PositionSource m_142460_() {
        if (this.blockPositionSource == null) {
            this.blockPositionSource = new BlockPositionSource(this.f_58858_);
        }
        return this.blockPositionSource;
    }

    public int m_142078_() {
        return 16;
    }

    public boolean m_214068_(ServerLevel world, GameEvent event, GameEvent.Context emitter, Vec3 emitterPos) {
        CustomGameEventHandler handler = gameEventHandlers.get(event);
        if (handler == null) {
            return false;
        }
        return handler.handle(this, world, event, emitter, emitterPos);
    }

    public static interface CustomGameEventHandler {
        public boolean handle(ModularWorkBenchEntity var1, ServerLevel var2, GameEvent var3, GameEvent.Context var4, Vec3 var5);
    }
}

