/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

@JsonAdapter(value=BlueprintJsonAdapter.class)
public class Blueprint {
    public static MiapiRegistry<Blueprint> blueprintRegistry = MiapiRegistry.getInstance(Blueprint.class);
    public ItemModule module = ItemModule.empty;
    public String key;
    public Map<ModuleProperty, JsonElement> upgrades = new HashMap<ModuleProperty, JsonElement>();
    public ModuleCondition isAllowed;
    public boolean writeToItem = true;

    public void writeToElement() {
    }

    public static class AlwaysAllowedCondition
    extends BlueprintCondition {
        public static AlwaysAllowedCondition ALWAYS_ALLOWED = new AlwaysAllowedCondition();

        private AlwaysAllowedCondition() {
        }

        @Override
        public BlueprintCondition fromJson(JsonElement element) {
            return ALWAYS_ALLOWED;
        }

        @Override
        public boolean isAllowed() {
            return true;
        }
    }

    public static abstract class BlueprintCondition {
        public abstract BlueprintCondition fromJson(JsonElement var1);

        public abstract boolean isAllowed();
    }

    public static class BlueprintJsonAdapter
    extends TypeAdapter<Blueprint> {
        public void write(JsonWriter jsonWriter, Blueprint blueprint) throws IOException {
        }

        public Blueprint read(JsonReader jsonReader) throws IOException {
            String key;
            JsonObject jsonObject = JsonParser.parseReader((JsonReader)jsonReader).getAsJsonObject();
            Blueprint blueprint = new Blueprint();
            blueprint.key = key = jsonObject.get("key").getAsString();
            if (jsonObject.has("module")) {
                blueprint.module = RegistryInventory.modules.get(jsonObject.get("module").getAsString());
            } else {
                Miapi.LOGGER.warn("Blueprints target module is invalid. Either Module is not loaded or Blueprint is setup wrong. " + key);
            }
            if (jsonObject.has("condition")) {
                blueprint.isAllowed = ConditionManager.get(jsonObject.get("condition"));
            } else {
                Miapi.LOGGER.warn("Blueprints target condition is invalid. Either Condition is not loaded or Blueprint is setup wrong. " + key);
            }
            return blueprint;
        }
    }
}

