/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.mixin.client.ElytraEntityModelAccessor;
import smartin.miapi.mixin.client.ElytraFeatureRendererAccessor;
import smartin.miapi.mixin.client.LivingEntityRendererAccessor;

@OnlyIn(value=Dist.CLIENT)
public class ArmorModelManager {
    public static List<ArmorPartProvider> partProviders = new ArrayList<ArmorPartProvider>();

    public static void renderArmorPiece(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EquipmentSlot armorSlot, ItemStack itemStack, LivingEntity entity, HumanoidModel outerModel, EntityModel entityModel, RenderLayerParent context) {
        partProviders.forEach(armorPartProvider -> {
            List<ArmorPart> armorParts = armorPartProvider.getParts(armorSlot, entity, outerModel, entityModel, context);
            armorParts.forEach(armorPart -> {
                matrices.m_85836_();
                String key = armorPart.apply(matrices, armorSlot, entity, outerModel, entityModel);
                MiapiItemModel miapiItemModel = MiapiItemModel.getItemModel(itemStack);
                if (miapiItemModel != null) {
                    miapiItemModel.render(key, matrices, ItemDisplayContext.HEAD, 0.0f, vertexConsumers, light, OverlayTexture.f_118083_);
                }
                matrices.m_85849_();
            });
        });
    }

    static {
        partProviders.add(new ModelPartProvider());
    }

    public static interface ArmorPartProvider {
        public List<ArmorPart> getParts(EquipmentSlot var1, LivingEntity var2, HumanoidModel<?> var3, EntityModel var4, RenderLayerParent var5);
    }

    public static interface ArmorPart {
        public String apply(PoseStack var1, EquipmentSlot var2, LivingEntity var3, HumanoidModel<?> var4, EntityModel var5);
    }

    public static final class ModelPartProvider
    implements ArmorPartProvider {
        private static final String[] modelParts = new String[]{"head", "hat", "left_arm", "right_arm", "left_leg", "right_leg", "body"};

        @Override
        public List<ArmorPart> getParts(EquipmentSlot equipmentSlot, LivingEntity livingEntity, HumanoidModel<?> model, EntityModel entityModel, RenderLayerParent context) {
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            for (String key : modelParts) {
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel1.m_102624_((EntityModel)model1);
                    ModelPart part = ModelPartProvider.getModelPart(model1, key);
                    part.m_104299_(matrixStack);
                    return key;
                });
            }
            return parts;
        }

        private static ModelPart getModelPart(HumanoidModel<?> model, String name) {
            return switch (name) {
                case "head" -> model.f_102808_;
                case "hat" -> model.f_102809_;
                case "left_arm" -> model.f_102812_;
                case "right_arm" -> model.f_102811_;
                case "left_leg" -> model.f_102814_;
                case "right_leg" -> model.f_102813_;
                default -> model.f_102810_;
            };
        }
    }

    public static final class ElytraPartProvider
    implements ArmorPartProvider {
        @Override
        public List<ArmorPart> getParts(EquipmentSlot equipmentSlot, LivingEntity livingEntity, HumanoidModel<?> model, EntityModel entityModel, RenderLayerParent context) {
            LivingEntityRenderer livingEntityRenderer;
            Optional<Object> elytraFeatureRenderer;
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            if (context instanceof LivingEntityRenderer && (elytraFeatureRenderer = ((LivingEntityRendererAccessor)(livingEntityRenderer = (LivingEntityRenderer)context)).getFeatures().stream().filter(a -> a instanceof ElytraLayer).findAny()).isPresent()) {
                ElytraModel elytraEntityModel = ((ElytraFeatureRendererAccessor)elytraFeatureRenderer.get()).getElytra();
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.m_102624_((EntityModel)elytraEntityModel);
                    entityModel1.m_102624_((EntityModel)model1);
                    ModelPart part = ((ElytraEntityModelAccessor)elytraEntityModel).getLeftWing();
                    part.m_104299_(matrixStack);
                    return "left_wing";
                });
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.m_102624_((EntityModel)elytraEntityModel);
                    entityModel1.m_102624_((EntityModel)model1);
                    ModelPart part = ((ElytraEntityModelAccessor)elytraEntityModel).getRightWing();
                    part.m_104299_(matrixStack);
                    return "right_wing";
                });
                return parts;
            }
            return parts;
        }
    }
}

