/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.cache.ModularItemCache;

@OnlyIn(value=Dist.CLIENT)
public class MaterialAtlasManager
extends TextureAtlasHolder {
    public static final ResourceLocation MATERIAL_ID = new ResourceLocation("miapi", "miapi_materials");
    public static final ResourceLocation MATERIAL_ATLAS_ID = new ResourceLocation("miapi", "textures/atlas/materials.png");
    public static final ResourceLocation BASE_MATERIAL_ID = new ResourceLocation("miapi", "miapi_materials/base_palette");
    protected final List<AddedSpriteEntry> addedSprites = new ArrayList<AddedSpriteEntry>();

    public MaterialAtlasManager(TextureManager textureManager) {
        super(textureManager, MATERIAL_ATLAS_ID, MATERIAL_ID);
    }

    public void addSpriteToLoad(ResourceLocation id) {
        this.addedSprites.add(new AddedSpriteEntry(id, s -> {}));
    }

    public void addSpriteToLoad(ResourceLocation id, Consumer<SpriteContents> onAdded) {
        this.addedSprites.add(new AddedSpriteEntry(id, onAdded));
    }

    public void m_245256_(SpriteLoader.Preparations invalidResult, ProfilerFiller profiler) {
        if (invalidResult != null) {
            return;
        }
        ++ReloadEvents.reloadCounter;
        ArrayList<SpriteContents> materialSprites = new ArrayList<SpriteContents>();
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        for (AddedSpriteEntry entry : this.addedSprites) {
            ResourceLocation id = entry.id;
            Resource resource = (Resource)manager.m_213713_(id).orElseThrow(() -> new RuntimeException(new FileNotFoundException(id.toString())));
            try {
                SpriteContents contents = SpriteLoader.m_245083_((ResourceLocation)id, (Resource)resource);
                if (contents == null) {
                    Miapi.LOGGER.warn("Sprite creation of '{}' failed for material atlas! See logger error(s) above.", (Object)id);
                    continue;
                }
                if (contents.m_246492_() != 256) {
                    Miapi.LOGGER.warn("Ignoring sprite '{}' for material atlas, as it does not have a width of 256!", (Object)id);
                    continue;
                }
                materialSprites.add(contents);
                entry.onCreated.accept(contents);
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Failed to add sprite '" + id + "' to material atlas!", (Throwable)e);
            }
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int shortMax = 32766;
        int width = ((int)(Math.floor((double)materialSprites.size() / (double)shortMax) * 256.0) + 1) * 256;
        int height = materialSprites.size() % shortMax + 5;
        int maxSize = Math.max(Math.max(512, width + 5), height + 5);
        SpriteLoader spriteLoader = new SpriteLoader(MATERIAL_ID, maxSize, width, height);
        SpriteLoader.Preparations stitchResult = spriteLoader.m_261295_(materialSprites, 0, (Executor)executor);
        profiler.m_7242_();
        profiler.m_6180_("upload");
        this.f_118884_.m_247065_(stitchResult);
        Miapi.LOGGER.info("Created material atlas with size {}x{}", (Object)width, (Object)height);
        profiler.m_7238_();
        profiler.m_7241_();
        ModularItemCache.discardCache();
        --ReloadEvents.reloadCounter;
    }

    public TextureAtlasSprite getMaterialSprite(ResourceLocation id) {
        TextureAtlasSprite sprite = this.m_118901_(id);
        if (sprite == null) {
            sprite = this.m_118901_(BASE_MATERIAL_ID);
        }
        return sprite;
    }

    public record AddedSpriteEntry(ResourceLocation id, Consumer<SpriteContents> onCreated) {
    }
}

