/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.palette.SpriteColorer;

public class MaterialSpriteManager {
    static Map<Holder, DynamicTexture> animated_Textures = new HashMap<Holder, DynamicTexture>();
    public static final long CACHE_SIZE = 10000L;
    public static final long CACHE_LIFETIME = 10L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.SECONDS;
    protected static Map<ResourceLocation, DynamicTexture> nativeImageBackedTextureMap = new HashMap<ResourceLocation, DynamicTexture>();
    public static Set<TextureAtlasSprite> animated = new HashSet<TextureAtlasSprite>();
    protected static final Cache<Holder, ResourceLocation> materialSpriteCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, CACHE_LIFETIME_UNIT).removalListener(notification -> {
        if (notification.wasEvicted()) {
            Object patt2292$temp;
            Object patt1870$temp = notification.getValue();
            if (patt1870$temp instanceof ResourceLocation) {
                ResourceLocation removeId = (ResourceLocation)patt1870$temp;
                DynamicTexture texture = nativeImageBackedTextureMap.get(removeId);
                if (texture != null) {
                    texture.close();
                }
                Minecraft.m_91087_().m_91097_().m_118513_(removeId);
            }
            if ((patt2292$temp = notification.getKey()) instanceof Holder) {
                Holder holder = (Holder)patt2292$temp;
                animated_Textures.remove(holder);
                try {
                    holder.colorer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }).build((CacheLoader)new CacheLoader<Holder, ResourceLocation>(){

        public ResourceLocation load(Holder key) {
            return MaterialSpriteManager.getMaterialSprite(key);
        }
    });

    public static ResourceLocation getMaterialSprite(TextureAtlasSprite oldSprite, Material material, SpriteColorer materialSpriteColorer) {
        Holder holder = new Holder(oldSprite, material, materialSpriteColorer);
        return MaterialSpriteManager.getMaterialSprite(holder);
    }

    public static ResourceLocation getMaterialSprite(Holder holder) {
        ResourceLocation identifier = (ResourceLocation)materialSpriteCache.getIfPresent((Object)holder);
        if (identifier == null) {
            SpriteColorer.MaterialRecoloredSpriteHolder colorer = holder.colorer().createSpriteManager(holder.sprite().m_245424_());
            DynamicTexture nativeImageBackedTexture = new DynamicTexture(colorer.recolor().m_266528_(IntUnaryOperator.identity()));
            ResourceLocation spriteId = Minecraft.m_91087_().m_91097_().m_118490_("miapi/dynmaterialsprites", nativeImageBackedTexture);
            if (colorer.requireTick()) {
                animated_Textures.put(holder, nativeImageBackedTexture);
            }
            materialSpriteCache.put((Object)holder, (Object)spriteId);
            return spriteId;
        }
        return identifier;
    }

    public static void clear() {
        materialSpriteCache.invalidateAll();
    }

    public static void tick() {
        if (!ReloadEvents.isInReload()) {
            ArrayList toRemove = new ArrayList();
            animated_Textures.forEach((holder, nativeImageBackedTexture) -> {
                try {
                    holder.colorer.tick(nativeImage -> {
                        nativeImageBackedTexture.m_117991_().m_85054_(nativeImage);
                        nativeImageBackedTexture.m_117985_();
                    }, holder.sprite().m_245424_());
                }
                catch (Exception e) {
                    toRemove.add(holder);
                }
            });
            toRemove.forEach(arg_0 -> materialSpriteCache.invalidate(arg_0));
        }
    }

    public static void markTextureAsAnimatedInUse(TextureAtlasSprite sprite) {
        if (MiapiClient.isSodiumLoaded()) {
            animated.add(sprite);
        }
    }

    public static void onHudRender(GuiGraphics drawContext) {
        VertexConsumer consumer = ItemRenderer.m_115211_((MultiBufferSource)drawContext.m_280091_(), (RenderType)RenderType.m_285907_(), (boolean)false, (boolean)false);
        int[] quadData = new int[32];
        for (TextureAtlasSprite sprite : animated) {
            BakedQuad bakedQuad = new BakedQuad(quadData, 0, Direction.DOWN, sprite, false);
            consumer.m_85987_(drawContext.m_280168_().m_85850_(), bakedQuad, 0.0f, 0.0f, 0.0f, 0, 0);
        }
        animated.clear();
    }

    public record Holder(TextureAtlasSprite sprite, Material material, SpriteColorer colorer) {
    }
}

