/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class BoxList
extends InteractAbleWidget {
    private List<List<AbstractWidget>> allRows = new ArrayList<List<AbstractWidget>>();
    private List<? extends AbstractWidget> currentWidgets = new ArrayList<AbstractWidget>();
    private int space = 5;

    public BoxList(int x, int y, int width, int height, Component message, List<AbstractWidget> widgets) {
        super(x, y, width, height, message);
        this.setWidgets(widgets, this.space);
    }

    public void setSpace(int space) {
        this.space = space;
        ArrayList widgets = new ArrayList();
        this.setWidgets(widgets, space);
    }

    public void setWidgets(@Nullable List<? extends AbstractWidget> widgets, int space) {
        this.children().clear();
        this.space = space;
        if (widgets == null) {
            widgets = new ArrayList<AbstractWidget>();
        }
        this.currentWidgets = widgets;
        LinkedHashMap byHeight = new LinkedHashMap();
        widgets.forEach(widget -> {
            byHeight.putIfAbsent(widget.m_93694_(), new ArrayList());
            ((List)byHeight.get(widget.m_93694_())).add(widget);
        });
        int currentHeight = this.m_252907_();
        while (!byHeight.isEmpty()) {
            List toAdd = (List)byHeight.remove(((HashMap)byHeight).keySet().stream().findAny().get());
            toAdd.sort(Comparator.comparingInt(AbstractWidget::m_93694_));
            while (!toAdd.isEmpty()) {
                AbstractWidget widget2 = (AbstractWidget)toAdd.remove(0);
                int currentWidth = 0;
                ArrayList<AbstractWidget> currentRow = new ArrayList<AbstractWidget>();
                currentRow.add(widget2);
                widget2.m_252865_(this.m_252754_() + currentWidth + space);
                widget2.m_253211_(currentHeight + space);
                this.addChild((GuiEventListener)widget2);
                currentWidth += widget2.m_5711_() + space;
                for (int i = 0; i < toAdd.size(); ++i) {
                    if (currentWidth + ((AbstractWidget)toAdd.get(i)).m_5711_() > this.m_5711_()) continue;
                    AbstractWidget next = (AbstractWidget)toAdd.remove(i);
                    next.m_252865_(this.m_252754_() + currentWidth + space);
                    next.m_253211_(currentHeight + space);
                    currentWidth += next.m_5711_() + space;
                    this.addChild((GuiEventListener)next);
                }
                currentHeight += widget2.m_93694_() + space;
                this.allRows.add(currentRow);
            }
        }
        this.f_93619_ = currentHeight - this.m_252907_();
    }

    public void m_252865_(int x) {
        if (this.m_252754_() != x) {
            super.m_252865_(x);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    public void m_253211_(int y) {
        if (this.m_252907_() != y) {
            super.m_253211_(y);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    public void m_93674_(int widths) {
        if (this.m_5711_() != this.f_93618_) {
            super.m_93674_(this.f_93618_);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
    }
}

