/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class HoverDescription
extends InteractAbleWidget {
    public List<FormattedCharSequence> lines;
    public ClientTooltipPositioner positioner = AbsoluteTooltipPositioner.INSTANCE;
    public int maxWidth = -1;

    public HoverDescription(int x, int y, Component unified) {
        super(x, y, 0, 0, (Component)Component.m_237119_());
        this.lines = new ArrayList<FormattedCharSequence>();
        for (String s : unified.getString().split("\\r?\\n")) {
            this.lines.add(Component.m_237113_((String)s).m_7532_());
        }
        this.updateSize(this.lines);
    }

    public HoverDescription(int x, int y, List<Component> text) {
        super(x, y, 0, 0, (Component)Component.m_237119_());
        this.lines = this.toOrderedText(text);
        this.updateSize(this.lines);
    }

    public List<FormattedCharSequence> toOrderedText(List<? extends FormattedText> list) {
        return list.stream().map(this::toOrderedText).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<FormattedCharSequence> toOrderedText(FormattedText visitable) {
        return Minecraft.m_91087_().f_91062_.m_92923_(visitable, this.maxWidth == -1 ? 10000 : this.maxWidth);
    }

    public void updateSize(List<FormattedCharSequence> lines) {
        int w = 0;
        int h = lines.size() == 1 ? -2 : 0;
        for (int e = 0; e < lines.size(); ++e) {
            FormattedCharSequence text = lines.get(e);
            ClientTooltipComponent tooltipComponent = ClientTooltipComponent.m_169948_((FormattedCharSequence)text);
            int compWidth = tooltipComponent.m_142069_(Minecraft.m_91087_().f_91062_);
            if (compWidth > w) {
                w = compWidth;
            }
            h += tooltipComponent.m_142103_();
        }
        this.f_93618_ = w;
        this.f_93619_ = h;
    }

    public void setText(Component unified) {
        this.lines = new ArrayList<FormattedCharSequence>();
        for (String s : unified.getString().split("\\r?\\n")) {
            this.lines.addAll(this.toOrderedText((FormattedText)Component.m_237113_((String)s)));
        }
        this.updateSize(this.lines);
    }

    public void setText(List<Component> text) {
        List<FormattedCharSequence> ordered = this.toOrderedText(text);
        this.lines = ordered;
        this.updateSize(ordered);
    }

    public void addText(Component text) {
        List<FormattedCharSequence> orderedText = this.toOrderedText((FormattedText)text);
        this.lines.addAll(orderedText);
        this.updateSize(orderedText);
    }

    public void addText(List<Component> text) {
        List<FormattedCharSequence> ordered = this.toOrderedText(text);
        this.lines.addAll(ordered);
        this.updateSize(ordered);
    }

    public void reset() {
        this.lines.clear();
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.m_280547_(Minecraft.m_91087_().f_91062_, this.lines, this.positioner, this.m_252754_(), this.m_252907_());
    }

    public static class AbsoluteTooltipPositioner
    implements ClientTooltipPositioner {
        public static final AbsoluteTooltipPositioner INSTANCE = new AbsoluteTooltipPositioner();

        protected AbsoluteTooltipPositioner() {
        }

        public Vector2ic m_262814_(int screenWidth, int screenHeight, int x, int y, int width, int height) {
            return new Vector2i(x, y).add(4, 4);
        }
    }
}

