/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

public class IntegerStatBar
extends InteractAbleWidget {
    int primaryValue = 0;
    int secondaryValue = 0;
    int maxSteps = 1;
    int primaryColor = 1;
    int secondaryColor = 1;
    int offColor = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0);
    int gapWidth = 1;
    int shadowSize = 1;

    public IntegerStatBar(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = Math.max(1, maxSteps);
    }

    public void setPrimary(int currentValue, int color) {
        this.primaryColor = color;
        this.primaryValue = currentValue;
    }

    public void setSecondary(int secondaryValue, int color) {
        this.secondaryColor = color;
        this.secondaryValue = secondaryValue;
    }

    public void setGapWidth(int gapWidth) {
        this.gapWidth = Math.max(0, gapWidth);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int newMaxSteps = Math.max(this.maxSteps, Math.max(this.primaryValue, this.secondaryValue));
        int stepWidth = (int)((double)(this.f_93618_ - this.gapWidth * (newMaxSteps - 1)) / (double)newMaxSteps);
        for (int i = 0; i < newMaxSteps; ++i) {
            int segmentX = this.m_252754_() + (stepWidth + this.gapWidth) * i;
            int segmentEndX = segmentX + stepWidth;
            if (i < this.primaryValue) {
                context.m_280509_(segmentX, this.m_252907_(), segmentEndX, this.f_93619_ + this.m_252907_(), this.primaryColor);
                continue;
            }
            if (i < this.secondaryValue) {
                context.m_280509_(segmentX, this.m_252907_(), segmentEndX, this.f_93619_ + this.m_252907_(), this.secondaryColor);
                continue;
            }
            context.m_280509_(segmentX, this.m_252907_(), segmentEndX, this.f_93619_ + this.m_252907_(), this.offColor);
        }
        IntegerStatBar.drawTextureWithEdge(context, CraftingScreen.BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_() + this.f_93619_, 339, 4, 7, 1, this.m_5711_(), this.shadowSize, 512, 512, 1);
    }
}

