/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector2d;
import smartin.miapi.config.MiapiConfig;

@OnlyIn(value=Dist.CLIENT)
public abstract class InteractAbleWidget
extends AbstractWidget
implements Renderable,
GuiEventListener {
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    protected final List<InteractAbleWidget> hoverElements = new ArrayList<InteractAbleWidget>();
    public boolean debug = false;
    public int randomColor = FastColor.ARGB32.m_13660_((int)180, (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)));

    protected InteractAbleWidget(int x, int y, int width, int height, Component title) {
        super(x, y, width, height, title);
    }

    public static void drawSquareBorder(GuiGraphics drawContext, int x, int y, int width, int height, int borderWidth, int color) {
        drawContext.m_280046_(x, y, x + width, y + borderWidth, 100, color);
        drawContext.m_280046_(x, y + height, x + width, y + height - borderWidth, 100, color);
        drawContext.m_280046_(x, y, x + borderWidth, y + height, 100, color);
        drawContext.m_280046_(x + width, y, x + width - borderWidth, y + height, 100, color);
    }

    public static void drawTextureWithEdgeAndScale(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth, float scale) {
        GuiGraphics context = new GuiGraphics(Minecraft.m_91087_(), drawContext.m_280091_());
        context.m_280168_().m_252931_(drawContext.m_280168_().m_85850_().m_252922_());
        context.m_280168_().m_85850_().m_252922_().scale(1.0f / scale);
        InteractAbleWidget.drawTextureWithEdge(context, texture, (int)((float)x * scale), (int)((float)y * scale), u, v, regionWidth, regionHeight, (int)((float)width * scale), (int)((float)height * scale), textureWidth, textureHeight, borderWidth);
    }

    public static void drawTextureWithEdge(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        drawContext.m_280411_(texture, x + borderWidth, y + borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, (float)(u + borderWidth), (float)(v + borderWidth), regionWidth - borderWidth * 2, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x, y, borderWidth, borderWidth, (float)u, (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x + width - borderWidth, y, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x, y + height - borderWidth, borderWidth, borderWidth, (float)u, (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x + width - borderWidth, y + height - borderWidth, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)(v + regionHeight - borderWidth), regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x + width - borderWidth, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)u, (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.m_280411_(texture, x + borderWidth, y, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)v, regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
    }

    public static void drawTextureWithEdge(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        InteractAbleWidget.drawTextureWithEdge(drawContext, texture, x, y, 0, 0, textureWidth, textureHeight, width, height, textureWidth, textureHeight, borderWidth);
    }

    public List<InteractAbleWidget> getHoverElements() {
        ArrayList<InteractAbleWidget> allHoverElements = new ArrayList<InteractAbleWidget>(this.hoverElements);
        this.children().forEach(currentChildren -> {
            if (currentChildren instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)currentChildren);
                allHoverElements.addAll(widget.getHoverElements());
            }
        });
        return allHoverElements;
    }

    public void addChild(GuiEventListener element) {
        this.children().add(element);
    }

    public void removeChild(GuiEventListener element) {
        this.children().remove(element);
    }

    public List<GuiEventListener> children() {
        return this.children;
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_5953_(mouseX, mouseY)) continue;
            child.m_94757_(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public void playClickedSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_6348_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_7920_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        for (GuiEventListener child : this.children()) {
            if (!child.m_5534_(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY);
    }

    public Vector2d getScaledMouseCoords() {
        Minecraft client = Minecraft.m_91087_();
        MouseHandler mouse = client.f_91067_;
        double x = mouse.m_91589_() * (double)client.m_91268_().m_85445_() / (double)client.m_91268_().m_85443_();
        double y = mouse.m_91594_() * (double)client.m_91268_().m_85446_() / (double)client.m_91268_().m_85444_();
        return new Vector2d(x, y);
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if ((this.debug || MiapiConfig.INSTANCE.server.other.developmentMode) && Screen.m_96639_()) {
            InteractAbleWidget.drawSquareBorder(drawContext, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 1, this.randomColor);
        }
        RenderSystem.setShader(GameRenderer::m_172808_);
        ArrayList<GuiEventListener> reverse = new ArrayList<GuiEventListener>(this.children());
        Collections.reverse(reverse);
        for (GuiEventListener element : reverse) {
            if (!(element instanceof Renderable)) continue;
            Renderable drawable = (Renderable)element;
            drawable.m_88315_(drawContext, mouseX, mouseY, delta);
        }
    }

    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hoverElements.forEach(widget -> widget.m_88315_(drawContext, mouseX, mouseY, delta));
        this.children().forEach(element -> {
            if (element instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)element);
                widget.renderHover(drawContext, mouseX, mouseY, delta);
            }
        });
    }

    protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }
}

