/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class MultiLineTextWidget
extends InteractAbleWidget {
    public Component rawText;
    public List<Component> lines = new ArrayList<Component>();
    private int longestLine;
    public int maxLineLength;
    public Font textRenderer;
    public int spacer;
    public boolean hasTextShadow;
    public int textColor;

    public MultiLineTextWidget(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.spacer = 1;
        this.hasTextShadow = true;
        this.textColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        this.maxLineLength = width;
        this.setText(text);
    }

    public void setText(Component text) {
        this.rawText = text;
        List rawLines = Arrays.stream(text.getString().split("\n")).collect(Collectors.toList());
        this.lines.clear();
        while (!rawLines.isEmpty()) {
            MutableComponent line;
            int size;
            String rawLine = (String)rawLines.remove(0);
            if (this.maxLineLength > 0 && this.textRenderer.m_92895_(rawLine) > this.maxLineLength) {
                ArrayList<String> words = new ArrayList<String>(Arrays.stream(rawLine.split(" ")).toList());
                StringBuilder currentLine = new StringBuilder();
                currentLine.append((String)words.remove(0));
                currentLine.append(" ");
                StringBuilder nextLine = new StringBuilder();
                int currentLineLength = 0;
                boolean isLineExceeded = false;
                for (String word : words) {
                    int wordLength = this.textRenderer.m_92895_(word);
                    if (!isLineExceeded && currentLineLength + wordLength + 1 <= this.maxLineLength) {
                        currentLine.append(word).append(" ");
                        currentLineLength = this.textRenderer.m_92895_(currentLine.toString());
                        continue;
                    }
                    nextLine.append(word).append(" ");
                    isLineExceeded = true;
                }
                if (isLineExceeded) {
                    rawLines.add(0, nextLine.toString());
                }
                rawLine = currentLine.toString().trim();
            }
            if ((size = this.textRenderer.m_92852_((FormattedText)(line = Component.m_237115_((String)rawLine)))) > this.longestLine) {
                this.longestLine = size;
            }
            this.lines.add((Component)line);
        }
        this.f_93618_ = this.longestLine;
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        this.f_93619_ = n * 9 + Math.max(0, this.lines.size() - 1) * this.spacer;
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int start = this.m_252907_();
        for (Component line : this.lines) {
            context.m_280614_(this.textRenderer, line, this.m_252754_(), start, this.textColor, this.hasTextShadow);
            Objects.requireNonNull(this.textRenderer);
            start += 9 + this.spacer;
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }
}

