/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ParentHandledScreen;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.MinimizeButton;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.DetailView;
import smartin.miapi.client.gui.crafting.crafter.ModuleCrafter;
import smartin.miapi.client.gui.crafting.slotdisplay.SlotDisplay;
import smartin.miapi.client.gui.crafting.slotdisplay.SmithDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.material.MaterialStatWidget;
import smartin.miapi.client.gui.crafting.statdisplay.material.StatDisplayWidget;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.AllowedSlots;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.registries.RegistryInventory;

public class CraftingScreen
extends ParentHandledScreen<CraftingScreenHandler>
implements MenuAccess<CraftingScreenHandler> {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("miapi", "textures/gui/crafter/background.png");
    private ItemStack stack;
    private ModuleCrafter moduleCrafter;
    private StatDisplayWidget statDisplay;
    private MaterialStatWidget materialStatWidget;
    private SlotDisplay slotDisplay;
    private SmithDisplay smithDisplay;
    private MinimizeButton minimizer;
    private SlotProperty.ModuleSlot baseSlot;
    @Nullable
    public static SlotProperty.ModuleSlot slot;
    @Nullable
    public static EditOption editOption;
    private TransformableWidget editHolder;
    static int editSpace;
    @Nullable
    public InteractAbleWidget hoverElement = null;
    static WeakReference<CraftingScreen> craftingScreenWeakReference;
    List<InteractAbleWidget> editOptionIcons = new ArrayList<InteractAbleWidget>();

    public CraftingScreen(CraftingScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, (Component)Component.m_237119_());
        slot = null;
        this.f_97726_ = 372;
        this.f_97727_ = 199;
        DetailView.scrollPos = 0;
        craftingScreenWeakReference = new WeakReference<CraftingScreen>(this);
    }

    @Nullable
    public static CraftingScreen getInstance() {
        if (craftingScreenWeakReference != null && craftingScreenWeakReference.get() != null) {
            return (CraftingScreen)((Object)craftingScreenWeakReference.get());
        }
        return null;
    }

    public EditOption getEditOption() {
        return editOption;
    }

    public void selectSlot(SlotProperty.ModuleSlot slot) {
        CraftingScreen.slot = slot;
        this.updateEditOptions();
    }

    public void previewStack(ItemStack itemStack) {
        this.slotDisplay.setItem(itemStack);
        this.statDisplay.setCompareTo(itemStack);
        this.smithDisplay.setPreview(itemStack);
    }

    public void selectEditOption(EditOption editOption) {
        CraftingScreen.editOption = editOption;
        this.moduleCrafter.setSelectedSlot(slot);
        this.moduleCrafter.setEditMode(editOption, this.get(editOption));
        PreviewManager.resetCursorStack();
    }

    public void m_7856_() {
        slot = null;
        editOption = null;
        ArrayList<String> allowedModules = new ArrayList<String>();
        allowedModules.add("melee");
        this.baseSlot = new SlotProperty.ModuleSlot(allowedModules);
        int centerX = (this.f_96543_ - this.f_97726_ - 6) / 2;
        int centerY = (this.f_96544_ - this.f_97727_) / 2;
        this.moduleCrafter = new ModuleCrafter(centerX + 51 - 15, centerY + 22 - 14, 144, 89, this::selectSlot, item -> {
            this.slotDisplay.setItem((ItemStack)item);
            this.statDisplay.setCompareTo((ItemStack)item);
            this.smithDisplay.setPreview((ItemStack)item);
        }, ((CraftingScreenHandler)this.f_97732_).inventory, ((CraftingScreenHandler)this.f_97732_)::addSlotByClient, ((CraftingScreenHandler)this.f_97732_)::removeSlotByClient);
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.f_97732_).packetID);
        this.addChild(this.moduleCrafter);
        this.slotDisplay = new SlotDisplay(ItemStack.f_41583_, centerX + 51 - 15, centerY + 117 - 14, 68, 87, selected -> {});
        this.slotDisplay.setItem(this.getItem());
        this.addChild(this.slotDisplay);
        this.smithDisplay = new SmithDisplay(centerX + 140 - 15, centerY + 117 - 14, 55, 70);
        this.addChild(this.smithDisplay);
        this.statDisplay = new StatDisplayWidget(centerX + 213 - 15, centerY + 30 - 14, 161, 95);
        this.addChild(this.statDisplay);
        this.minimizer = new MinimizeButton(centerX + 178 - 15, centerY + 188 - 14, 18, 18, this::minimizeView, this::maximizeView);
        this.addChild(this.minimizer);
        super.m_7856_();
        this.f_97730_ = -1000;
        this.f_97731_ = -1000;
        this.editHolder = new TransformableWidget(this.f_97735_ - 15, this.f_97736_ - 14, 0, 0, (Component)Component.m_237119_());
        this.addChild(this.editHolder);
        this.updateItem(((CraftingScreenHandler)this.f_97732_).inventory.m_8020_(0));
        if (this.moduleCrafter != null) {
            this.moduleCrafter.handler = (CraftingScreenHandler)this.f_97732_;
        }
        ((CraftingScreenHandler)this.f_97732_).m_38893_(new SimpleScreenHandlerListener((TriConsumer<AbstractContainerMenu, Integer, ItemStack>)((TriConsumer)(handler, slotId, stack) -> {
            if (slotId == 36) {
                this.updateItem((ItemStack)stack);
            }
        })));
        this.addChild(new EditOptionIcon(this.moduleCrafter.m_252754_() - 36, this.moduleCrafter.m_252907_() + 4, 32, 28, this::selectEditOption, this::getEditOption, BACKGROUND_TEXTURE, 339, 25, 512, 512, "miapi.ui.edit_option.hover.info", null));
        this.selectEditOption(null);
        this.selectSlot(null);
        this.previewStack(((CraftingScreenHandler)this.f_97732_).inventory.m_8020_(0));
        PreviewManager.resetCursorStack();
        PreviewManager.resetPreview();
    }

    public int getBackgroundHeight() {
        return this.f_97727_;
    }

    public int getBackgroundWidth() {
        return this.f_97726_;
    }

    public void minimizeView() {
        EditOption op = this.getEditOption();
        this.m_169411_(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.m_252754_(), this.moduleCrafter.m_252907_(), this.moduleCrafter.m_5711_(), this.moduleCrafter.m_93694_() + 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.f_97732_;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.f_97732_).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.m_169411_(this.slotDisplay);
        this.m_169411_(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
    }

    public void maximizeView() {
        EditOption op = this.getEditOption();
        this.m_169411_(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.m_252754_(), this.moduleCrafter.m_252907_(), this.moduleCrafter.m_5711_(), this.moduleCrafter.m_93694_() - 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.f_97732_;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.f_97732_).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.addChild(this.slotDisplay);
        this.addChild(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
    }

    public ItemStack getItem() {
        return ((CraftingScreenHandler)this.f_97732_).inventory.m_8020_(0);
    }

    public void setItem(ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.f_41583_;
        }
        this.slotDisplay.setItem(stack);
        ((CraftingScreenHandler)this.f_97732_).inventory.m_6836_(0, stack);
    }

    public void updateItem(ItemStack stack) {
        PreviewManager.resetCursorStack();
        this.updatePreviewItemStack(stack);
    }

    public void updatePreviewItemStack(ItemStack stack) {
        stack = stack.m_41777_();
        this.slotDisplay.setItem(stack);
        ItemStack converted = ModularItemStackConverter.getModularVersion(stack).m_41777_();
        this.baseSlot.inSlot = ItemModule.getModules(converted);
        this.baseSlot.allowed = AllowedSlots.getAllowedSlots(this.baseSlot.inSlot.module);
        SlotProperty.ModuleSlot current = this.baseSlot;
        slot = null;
        if (this.baseSlot.inSlot.module.equals(ItemModule.empty)) {
            current = null;
        }
        if (this.moduleCrafter != null) {
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
        }
        if (this.slotDisplay != null) {
            this.slotDisplay.setItem(converted);
            this.slotDisplay.select(current);
        }
        if (this.smithDisplay != null) {
            this.smithDisplay.setPreview(converted);
        }
        if (this.statDisplay != null) {
            this.statDisplay.setItemsOriginal(converted, converted);
        }
        this.updateEditOptions();
    }

    public void updateEditOptions() {
        int x = this.moduleCrafter.m_252754_() - 36;
        int y = this.moduleCrafter.m_252907_() + 4 + editSpace;
        for (InteractAbleWidget widget : this.editOptionIcons) {
            this.editHolder.removeChild(widget);
        }
        this.editHolder.children().clear();
        for (EditOption option : RegistryInventory.editOptions.getFlatMap().values()) {
            EditOption.EditContext context;
            if (!option.isVisible(context = this.get(option))) continue;
            InteractAbleWidget widget = option.getIconGui(x, y, 32, 28, this::selectEditOption, this::getEditOption);
            y += editSpace;
            this.editHolder.addChild(widget);
            this.editOptionIcons.add(widget);
        }
        if (!this.editHolder.children().contains(editOption)) {
            editOption = null;
        }
        PreviewManager.resetCursorStack();
        this.selectEditOption(editOption);
    }

    public EditOption.EditContext get(final EditOption editOption) {
        return new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf craftBuffer) {
                if (editOption != null) {
                    editOption.execute(craftBuffer, this);
                }
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                if (editOption != null) {
                    CraftingScreen.this.previewStack(editOption.preview(preview, this));
                }
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public ItemStack getItemstack() {
                return CraftingScreen.this.moduleCrafter.stack;
            }

            @Override
            @Nullable
            public ItemModule.ModuleInstance getInstance() {
                if (this.getSlot() == null) {
                    return null;
                }
                return this.getSlot().inSlot;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.m_91087_().f_91074_;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }
        };
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_280273_(drawContext);
        int i = (this.f_96543_ - this.f_97726_ - 6) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.hoverElement == null) {
            drawContext.m_280411_(BACKGROUND_TEXTURE, i + 43 - 15, j + 14 - 14, 338, 199, 0.0f, 0.0f, 338, 199, 512, 512);
            if (this.minimizer.isEnabled()) {
                drawContext.m_280411_(BACKGROUND_TEXTURE, i + 43 - 15, j + 111 - 14, 160, 95, 0.0f, 199.0f, 160, 95, 512, 512);
            }
        }
        if (this.hoverElement == null) {
            super.m_88315_(drawContext, mouseX, mouseY, delta);
        } else {
            this.hoverElement.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        this.m_280072_(drawContext, mouseX, mouseY);
        drawContext.m_280168_().m_85836_();
        drawContext.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        if (this.hoverElement == null) {
            drawContext.m_286007_(() -> this.renderHover(drawContext, mouseX, mouseY, delta));
        } else {
            drawContext.m_286007_(() -> this.hoverElement.renderHover(drawContext, mouseX, mouseY, delta));
        }
        drawContext.m_280168_().m_85849_();
        PreviewManager.tick();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        if (this.hoverElement != null) {
            this.hoverElement.m_94757_(mouseX, mouseY);
        } else {
            super.m_94757_(mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.hoverElement != null) {
            return this.hoverElement.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.hoverElement != null) {
            return this.hoverElement.m_6050_(mouseX, mouseY, amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    static {
        editSpace = 30;
        craftingScreenWeakReference = new WeakReference<Object>(null);
    }
}

