/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class EditView
extends InteractAbleWidget {
    ItemStack stack;
    ItemModule.ModuleInstance instance;
    Consumer<ItemStack> previewConsumer;
    Consumer<Object> back;
    List<GuiEventListener> defaultChildren = new ArrayList<GuiEventListener>();
    EditOption.EditContext editContext;
    SlotProperty.ModuleSlot slot;
    List<Slot> currentSlots = new ArrayList<Slot>();

    public EditView(int x, int y, int width, int height, final ItemStack stack, final @Nullable SlotProperty.ModuleSlot slot, Consumer<ItemStack> preview, Consumer<Object> back) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.previewConsumer = preview;
        this.stack = stack;
        this.slot = slot;
        if (slot != null) {
            this.instance = slot.inSlot;
        }
        this.clearSlots();
        this.back = back;
        float headerScale = 1.5f;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.defaultChildren.add(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.m_252754_() + 5) / headerScale), (int)((float)this.m_252907_() / headerScale), (int)((float)(this.f_93618_ - 10) / headerScale), (Component)Component.m_237115_((String)"miapi.ui.edit.header"), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        ScrollList list = new ScrollList(x, y + 16, width, height - 14, new ArrayList<InteractAbleWidget>());
        this.defaultChildren.add(list);
        list.children().clear();
        this.defaultChildren.add(new SimpleButton<Object>(this.m_252754_() + 2, this.m_252907_() + this.f_93619_ - 10, 40, 12, (Component)Component.m_237115_((String)"miapi.ui.back"), stack, back));
        ArrayList<InteractAbleWidget> toList = new ArrayList<InteractAbleWidget>();
        this.editContext = new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf packetByteBuf) {
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public ItemStack getItemstack() {
                return stack;
            }

            @Override
            @Nullable
            public ItemModule.ModuleInstance getInstance() {
                return EditView.this.instance;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.m_91087_().f_91074_;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }
        };
        RegistryInventory.editOptions.getFlatMap().forEach((s, editOption) -> {
            if (editOption.isVisible(this.editContext)) {
                ItemModule.ModuleInstance moduleInstance = null;
                if (this.instance != null) {
                    moduleInstance = this.instance.copy();
                }
                toList.add(new SlotButton(0, 0, this.f_93618_, 15, (String)s, (EditOption)editOption, moduleInstance));
            }
        });
        list.setList(toList);
        this.setDefaultChildren();
    }

    public void clearSlots() {
        this.currentSlots.forEach(slot1 -> {
            AbstractContainerMenu patt5525$temp = Minecraft.m_91087_().f_91074_.f_36096_;
            if (patt5525$temp instanceof CraftingScreenHandler) {
                CraftingScreenHandler handler = (CraftingScreenHandler)patt5525$temp;
                handler.removeSlotByClient((Slot)slot1);
            }
        });
    }

    private void setDefaultChildren() {
        this.children().clear();
        this.defaultChildren.forEach(this::addChild);
    }

    public void setEditOption(final EditOption option) {
        this.editContext = new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf packetByteBuf) {
                CraftingScreenHandler screenHandler = this.getScreenHandler();
                if (screenHandler instanceof CraftingScreenHandler) {
                    CraftingScreenHandler screenHandler1 = screenHandler;
                    ItemModule.ModuleInstance toCrafter = EditView.this.instance;
                    FriendlyByteBuf buf = Networking.createBuffer();
                    buf.m_130070_(RegistryInventory.editOptions.findKey(option));
                    ArrayList<Integer> position = new ArrayList<Integer>();
                    if (toCrafter != null) {
                        toCrafter.calculatePosition(position);
                    } else if (EditView.this.slot != null && EditView.this.slot.parent != null) {
                        EditView.this.slot.parent.calculatePosition(position);
                        position.add(EditView.this.slot.id);
                    }
                    int[] positionArray = position.stream().mapToInt(Integer::intValue).toArray();
                    buf.m_130089_(positionArray);
                    buf.writeBytes(packetByteBuf.copy());
                    Networking.sendC2S(screenHandler1.editPacketID, buf);
                }
                this.preview(packetByteBuf);
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                EditView.this.previewConsumer.accept(option.preview(preview, this));
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return EditView.this.slot;
            }

            @Override
            public ItemStack getItemstack() {
                return EditView.this.stack;
            }

            @Override
            @Nullable
            public ItemModule.ModuleInstance getInstance() {
                return EditView.this.instance;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.m_91087_().f_91074_;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public void addSlot(Slot slot) {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    craftingScreenHandler.addSlotByClient(slot);
                    EditView.this.currentSlots.add(slot);
                }
            }

            @Override
            public void removeSlot(Slot slot) {
                AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    craftingScreenHandler.removeSlotByClient(slot);
                    EditView.this.currentSlots.remove(slot);
                }
            }
        };
        this.children().clear();
        this.addChild(option.getGui(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.editContext));
    }

    class SlotButton
    extends InteractAbleWidget {
        private final ResourceLocation texture;
        private final ScrollingTextWidget textWidget;
        private final EditOption option;

        public SlotButton(int x, int y, int width, int height, String editName, EditOption option, ItemModule.ModuleInstance instance) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.texture = new ResourceLocation("miapi", "textures/gui/crafter/module_button_select.png");
            Component translated = StatResolver.translateAndResolve("miapi.edit.option." + editName, instance);
            this.textWidget = new ScrollingTextWidget(0, 0, this.f_93618_, translated, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.option = option;
        }

        @Override
        public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int hoverOffset = 0;
            if (this.m_5953_(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            SlotButton.drawTextureWithEdge(drawContext, this.texture, this.m_252754_(), this.m_252907_(), 0, hoverOffset, 140, 14, this.m_5711_(), this.m_93694_(), 140, 42, 2);
            this.textWidget.m_252865_(this.m_252754_() + 2);
            this.textWidget.m_253211_(this.m_252907_() + 3);
            this.textWidget.m_93674_(this.f_93618_ - 4);
            this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY) && button == 0) {
                EditView.this.setEditOption(this.option);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

