/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.DetailView;
import smartin.miapi.client.gui.crafting.crafter.EditView;
import smartin.miapi.client.gui.crafting.crafter.MaterialDetailView;
import smartin.miapi.client.gui.crafting.crafter.help.HelpGuiInfo;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.ReplaceView;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.network.Networking;

@OnlyIn(value=Dist.CLIENT)
public class ModuleCrafter
extends InteractAbleWidget {
    public ItemStack stack;
    public SlotProperty.ModuleSlot slot;
    private final Consumer<ItemStack> preview;
    private SlotProperty.ModuleSlot baseSlot = new SlotProperty.ModuleSlot(new ArrayList<String>());
    private String paketIdentifier;
    private Container linkedInventory;
    EditView editView;
    Consumer<Slot> removeSlot;
    Consumer<Slot> addSlot;
    public CraftingScreenHandler handler;
    EditOption editOption;
    Consumer<SlotProperty.ModuleSlot> selected;
    public EditOption.EditContext editContext;
    Mode currentMode = Mode.DETAIL;
    CraftOption craftOption;
    public String moduleType = "default";

    public ModuleCrafter(int x, int y, int width, int height, Consumer<SlotProperty.ModuleSlot> selected, Consumer<ItemStack> craftedItem, Container linkedInventory, Consumer<Slot> addSlot, Consumer<Slot> removeSlot) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.selected = selected;
        this.linkedInventory = linkedInventory;
        this.preview = craftedItem;
        this.removeSlot = removeSlot;
        this.addSlot = addSlot;
    }

    public ModuleCrafter(int x, int y, int width, int height, ModuleCrafter other) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.selected = other.selected;
        this.linkedInventory = other.linkedInventory;
        this.preview = other.preview;
        this.removeSlot = other.removeSlot;
        this.addSlot = other.addSlot;
    }

    public void setItem(ItemStack stack) {
        this.stack = stack;
    }

    public void setSelectedSlot(SlotProperty.ModuleSlot instance) {
        this.slot = instance;
        this.setMode(Mode.DETAIL);
    }

    public void setBaseSlot(SlotProperty.ModuleSlot instance) {
        this.baseSlot = instance;
    }

    public void setPacketIdentifier(String identifier) {
        this.paketIdentifier = identifier;
    }

    public void setEditMode(EditOption editOption, EditOption.EditContext editContext) {
        if (editOption != null) {
            this.editOption = editOption;
            this.editContext = editContext;
            this.setMode(Mode.EDIT);
        }
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        if (mode != Mode.EDIT && this.editView != null) {
            this.editView.clearSlots();
        }
        if (mode == Mode.DETAIL && !(this.stack.m_41720_() instanceof VisualModularItem)) {
            Material material = MaterialProperty.getMaterialFromIngredient(this.stack);
            if (material != null) {
                mode = Mode.MATERIAL;
            }
            if (this.stack.m_41619_()) {
                mode = Mode.HELP;
            }
        }
        switch (mode) {
            case DETAIL: {
                this.children().clear();
                InteractAbleWidget detailView = new DetailView(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.baseSlot, this.slot, toEdit -> this.selected.accept((SlotProperty.ModuleSlot)toEdit), toReplace -> {
                    if (toReplace == null) {
                        ArrayList<String> allowed = new ArrayList<String>();
                        allowed.add("");
                        allowed.add("melee");
                        toReplace = new SlotProperty.ModuleSlot(allowed);
                    }
                    this.slot = toReplace;
                    this.setMode(Mode.REPLACE);
                }, this.moduleType);
                this.children.add(detailView);
                break;
            }
            case EDIT: {
                this.editView = new EditView(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.stack, this.slot, previewItem -> {
                    if (this.currentMode == Mode.EDIT) {
                        this.preview.accept((ItemStack)previewItem);
                    }
                }, object -> this.setMode(Mode.DETAIL));
                if (this.editOption != null) {
                    this.editView.setEditOption(this.editOption);
                }
                this.children().clear();
                this.addChild(this.editView);
                break;
            }
            case REPLACE: {
                this.children.clear();
                ReplaceView view = new ReplaceView(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, this.slot, this.editContext, this::setSelectedSlot, option -> {
                    this.craftOption = option;
                    this.setMode(Mode.CRAFT);
                }, option -> {
                    CraftAction action = new CraftAction(this.editContext.getItemstack(), this.editContext.getSlot(), option.module(), this.editContext.getPlayer(), this.editContext.getWorkbench(), option.data());
                    action.setItem(this.editContext.getLinkedInventory().m_8020_(0));
                    action.linkInventory(this.editContext.getLinkedInventory(), 1);
                    this.editContext.preview(action.toPacket(Networking.createBuffer()));
                });
                this.addChild(view);
                break;
            }
            case MATERIAL: {
                this.children.clear();
                InteractAbleWidget detailView = new MaterialDetailView(this.m_252754_(), this.m_252907_(), this.f_93618_, this.m_93694_(), this.stack, object -> this.setMode(Mode.DETAIL));
                this.addChild(detailView);
                break;
            }
            case HELP: {
                this.children().clear();
                CraftingScreen craftingScreen = CraftingScreen.getInstance();
                this.addChild(new HelpGuiInfo(this.m_252754_(), this.m_252907_(), this.f_93618_, this.m_93694_(), (Component)Component.m_237113_((String)"miapi.help.helper"), toFocus -> {
                    craftingScreen.hoverElement = toFocus;
                }, toRemove -> {
                    craftingScreen.hoverElement = null;
                }));
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    public static enum Mode {
        DETAIL,
        EDIT,
        REPLACE,
        CRAFT,
        MATERIAL,
        HELP;

    }
}

