/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.AllowedMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;

public class HoverMaterialList
extends InteractAbleWidget {
    public Map<String, List<Material>> materials = new LinkedHashMap<String, List<Material>>();
    public List<String> materialKeys;
    public int selected = 0;
    public int scrollPosOne = 0;
    public int scrollPosTwo = 0;
    final int maxElements = 8;
    final int selectedColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    final int unselectedColor = FastColor.ARGB32.m_13660_((int)255, (int)200, (int)200, (int)200);
    final int moreEntryColor = FastColor.ARGB32.m_13660_((int)255, (int)160, (int)160, (int)160);

    public HoverMaterialList(ItemModule module, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.materialKeys = AllowedMaterial.property.getAllowedKeys(module);
        for (String key : this.materialKeys) {
            this.materials.put(key, AllowedMaterial.property.getMaterials(key).stream().sorted(Comparator.comparing(m -> m.getTranslation().getString())).toList());
        }
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.m_280163_(CraftingScreen.BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), 404.0f, 96.0f, 20, 11, 512, 512);
        super.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.m_5953_(mouseX, mouseY)) {
            RenderSystem.disableDepthTest();
            int currentY = this.m_252907_() + 3;
            String selectedMaterialOrGroup = this.materialKeys.get(this.selected + this.scrollPosOne);
            List<Material> materialList = this.materials.get(selectedMaterialOrGroup);
            int sizeBaseList = 30;
            int verticalSize = Math.min(this.materials.size(), 8);
            verticalSize = Math.max(Math.min(materialList.size(), 8), verticalSize);
            for (int i = this.scrollPosOne; i < Math.min(this.materials.size(), 8 + this.scrollPosOne); ++i) {
                Component material = HoverMaterialList.getTranslation(this.materialKeys.get(i));
                sizeBaseList = Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)material), sizeBaseList);
            }
            int sizeDetailList = 0;
            if (materialList.size() > 1) {
                for (Material m : materialList) {
                    Component material = m.getTranslation();
                    sizeDetailList = Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)material), sizeDetailList);
                }
            }
            drawContext.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + sizeDetailList + sizeBaseList + 10, this.m_252907_() + verticalSize * 14, FastColor.ARGB32.m_13660_((int)210, (int)0, (int)0, (int)0));
            if (!this.materials.isEmpty()) {
                int start = this.scrollPosOne = Math.max(0, Math.min(this.materials.size() - 8 - 1, this.scrollPosOne));
                int end = Math.min(this.scrollPosOne + 8, this.materials.size());
                if (end < this.materials.size() - 1) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.lower.scroll"), this.m_252754_() + 3, currentY + 98, this.moreEntryColor, false);
                    --end;
                }
                if (start != 0) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.higher.scroll"), this.m_252754_() + 3, currentY, this.moreEntryColor, false);
                    ++start;
                    currentY += 14;
                }
                for (int i = start; i < end; ++i) {
                    int color = i == this.selected + this.scrollPosOne ? this.selectedColor : this.unselectedColor;
                    Component translation = HoverMaterialList.getTranslation(this.materialKeys.get(i));
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, translation, this.m_252754_() + 3, currentY, color, false);
                    currentY += 14;
                }
            }
            currentY = this.m_252907_() + 3;
            if (materialList.size() > 1) {
                int start = this.scrollPosTwo = Math.max(0, Math.min(materialList.size() - 8 - 1, this.scrollPosTwo));
                int end = Math.min(this.scrollPosTwo + 8 - 1, materialList.size() - 1);
                if (end < materialList.size() - 2) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.lower"), this.m_252754_() + sizeBaseList + 6, currentY + 98, this.moreEntryColor, false);
                    --end;
                }
                if (start != 0) {
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"miapi.ui.material_detail.higher"), this.m_252754_() + sizeBaseList + 6, currentY, this.moreEntryColor, false);
                    ++start;
                    currentY += 14;
                }
                for (int i = start; i <= end; ++i) {
                    Component material = HoverMaterialList.getTranslation(materialList.get(i).getKey());
                    drawContext.m_280614_(Minecraft.m_91087_().f_91062_, material, this.m_252754_() + sizeBaseList + 6, currentY, this.unselectedColor, false);
                    currentY += 14;
                }
            }
            RenderSystem.enableDepthTest();
        } else {
            this.scrollPosOne = 0;
            this.scrollPosTwo = 0;
            this.selected = 0;
        }
    }

    public static Component getTranslation(String materialOrGroupKey) {
        if (MaterialProperty.materials.containsKey(materialOrGroupKey)) {
            Material material = MaterialProperty.materials.get(materialOrGroupKey);
            return Component.m_237115_((String)material.getData("translation"));
        }
        MutableComponent testTranslation = Component.m_237115_((String)("miapi.material_group." + materialOrGroupKey));
        if (testTranslation.getString().equals("miapi.material_group." + materialOrGroupKey)) {
            return Component.m_237113_((String)materialOrGroupKey);
        }
        return testTranslation;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (Screen.m_96638_() || Screen.m_96637_()) {
                this.scrollPosTwo = amount < 0.0 ? ++this.scrollPosTwo : --this.scrollPosTwo;
                return true;
            }
            if (amount < 0.0) {
                int maxElementsTotal = this.materialKeys.size();
                if (this.selected + this.scrollPosOne != maxElementsTotal - 1) {
                    if (this.scrollPosOne == 0 && 8 == maxElementsTotal) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.scrollPosOne + 8 == maxElementsTotal - 1) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.selected == 6) {
                        ++this.scrollPosOne;
                    } else {
                        this.selected = Math.min(this.selected + 1, 7);
                    }
                }
            } else if (this.selected == 1 && this.scrollPosOne > 0) {
                --this.scrollPosOne;
            } else {
                this.selected = Math.max(this.selected - 1, 0);
            }
            return true;
        }
        return false;
    }
}

