/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.AttributeProperty;

@OnlyIn(value=Dist.CLIENT)
public class AttributeSingleDisplay
extends SingleStatDisplayDouble {
    public static Set<Attribute> attributesWithDisplay = new HashSet<Attribute>();
    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> oldItemCache = new WeakHashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> compareItemCache = new WeakHashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
    public AttributeModifier.Operation operation = AttributeModifier.Operation.ADDITION;
    final Attribute attribute;
    final EquipmentSlot slot;
    double defaultValue;
    public SingleStatDisplayDouble.StatReaderHelper valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

        @Override
        public double getValue(ItemStack itemStack) {
            return AttributeSingleDisplay.this.getValueFunction(itemStack);
        }

        @Override
        public boolean hasValue(ItemStack itemStack) {
            return AttributeSingleDisplay.this.hasAttribute(itemStack);
        }
    };

    private AttributeSingleDisplay(Attribute attribute, EquipmentSlot slot, StatListWidget.TextGetter text, StatListWidget.TextGetter hover, double defaultValue, DecimalFormat modifierFormat) {
        super(0, 0, 51, 19, text, hover);
        attributesWithDisplay.add(attribute);
        this.slot = slot;
        this.attribute = attribute;
        this.defaultValue = defaultValue;
        this.modifierFormat = modifierFormat;
    }

    @Override
    public double getValue(ItemStack stack) {
        double value = this.valueReader.getValue(stack);
        if (!this.valueReader.hasValue(stack) || Double.isNaN(value)) {
            return this.attribute.m_22082_();
        }
        return value;
    }

    public double getValueFunction(ItemStack stack) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributeCache = compareItemCache;
        if (stack.equals(this.original)) {
            attributeCache = oldItemCache;
        }
        if (this.slot == null) {
            Double value = null;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Multimap<Attribute, AttributeModifier> currentSlot = attributeCache.get(equipmentSlot);
                if (!attributeCache.get(equipmentSlot).containsKey((Object)this.attribute)) continue;
                switch (this.operation) {
                    case ADDITION: {
                        value = this.defaultValue;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.m_22217_().equals((Object)this.operation)).toList()) {
                            value = value + modifier.m_22218_();
                        }
                        return value;
                    }
                    case MULTIPLY_BASE: {
                        value = 0.0;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)).toList()) {
                            value = value + modifier.m_22218_();
                        }
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)).toList()) {
                            value = (value + 1.0) * (modifier.m_22218_() + 1.0) - 1.0;
                        }
                        return value * 100.0;
                    }
                    case MULTIPLY_TOTAL: {
                        value = 1.0;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.m_22217_().equals((Object)this.operation)).toList()) {
                            value = value * modifier.m_22218_();
                        }
                        return value * 100.0;
                    }
                }
            }
            return this.defaultValue;
        }
        return AttributeProperty.getActualValue(attributeCache.get(this.slot), this.attribute, this.defaultValue);
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        if (this.valueReader.hasValue(original)) {
            return true;
        }
        return this.valueReader.hasValue(compareTo);
    }

    public boolean hasAttribute(ItemStack itemStack) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributeCache = compareItemCache;
        if (itemStack.equals(this.original)) {
            attributeCache = oldItemCache;
        }
        if (this.slot == null) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                List<AttributeModifier> attrCollection;
                Multimap<Attribute, AttributeModifier> slotMap = attributeCache.get(equipmentSlot);
                if (slotMap == null || !this.hasValue(attrCollection = attributeCache.get(equipmentSlot).get((Object)this.attribute).stream().filter(attribute -> attribute.m_22217_().equals((Object)this.operation)).toList())) continue;
                return true;
            }
        } else {
            Multimap<Attribute, AttributeModifier> slotMap = attributeCache.get(this.slot);
            if (slotMap != null) {
                Collection attrCollection = attributeCache.get(this.slot).get((Object)this.attribute);
                return this.hasValue(attrCollection);
            }
        }
        return false;
    }

    public boolean hasValue(Collection<AttributeModifier> list) {
        list = list.stream().filter(attribute -> attribute.m_22217_().equals((Object)this.operation)).toList();
        if (this.operation.equals((Object)AttributeModifier.Operation.ADDITION)) {
            double value = AttributeProperty.getActualValue(list, this.attribute.m_22082_());
            return value != this.attribute.m_22082_() && !Double.isNaN(value);
        }
        return !list.isEmpty();
    }

    public static Builder builder(Attribute attribute) {
        return new Builder(attribute);
    }

    public static class Builder {
        Attribute attribute;
        public EquipmentSlot slot;
        public double defaultValue = 1.0;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.m_237119_();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public ValueGetter valueGetter;

        private Builder(Attribute attribute) {
            this.attribute = attribute;
            this.name = itemStack -> Component.m_237115_((String)attribute.m_22087_());
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            this.defaultValue = attribute.m_22082_();
            this.max = Math.min(2048.0, attribute.m_6740_(Double.MAX_VALUE));
            this.min = Math.max(-2048.0, attribute.m_6740_(Double.MIN_VALUE));
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setDefault(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> Component.m_237115_((String)("miapi.stat." + key));
            this.hoverDescription = stack -> Component.m_237110_((String)("miapi.stat." + key + ".description"), (Object[])this.descriptionArgs);
            return this;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder inverseNumber(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setSlot(EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setValueGetter(ValueGetter reader) {
            this.valueGetter = reader;
            return this;
        }

        public AttributeSingleDisplay[] build() {
            AttributeSingleDisplay[] displays = new AttributeSingleDisplay[2];
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.attribute == null) {
                throw new IllegalStateException("Attribute is required");
            }
            final AttributeSingleDisplay display = new AttributeSingleDisplay(this.attribute, this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            display.minValue = this.min;
            display.maxValue = this.max;
            display.setInverse(this.inverse);
            if (this.valueGetter != null) {
                display.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return display.hasAttribute(itemStack);
                    }
                };
            }
            display.operation = AttributeModifier.Operation.ADDITION;
            displays[0] = display;
            final AttributeSingleDisplay displayMulBase = new AttributeSingleDisplay(this.attribute, this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulBase.minValue = 0.0;
            displayMulBase.maxValue = 100.0;
            displayMulBase.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulBase.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return displayMulBase.hasAttribute(itemStack);
                    }
                };
            }
            displayMulBase.operation = AttributeModifier.Operation.MULTIPLY_BASE;
            displayMulBase.postfix = Component.m_237113_((String)"%");
            displays[1] = displayMulBase;
            final AttributeSingleDisplay displayMulTotal = new AttributeSingleDisplay(this.attribute, this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulTotal.minValue = 0.0;
            displayMulTotal.maxValue = 100.0;
            displayMulTotal.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulTotal.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return displayMulTotal.hasAttribute(itemStack);
                    }
                };
            }
            displayMulTotal.operation = AttributeModifier.Operation.MULTIPLY_TOTAL;
            displayMulTotal.postfix = Component.m_237113_((String)"%");
            return displays;
        }

        static interface ValueGetter {
            public double getValue(ItemStack var1);
        }
    }
}

