/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;

@OnlyIn(value=Dist.CLIENT)
public abstract class SingleStatDisplayBoolean
extends SingleStatDisplayDouble {
    protected SingleStatDisplayBoolean(int x, int y, int width, int height, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(x, y, width, height, title, hover);
        this.minValue = 0.0;
        this.maxValue = 1.0;
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.getValueItemStack(stack) ? 1.0 : 0.0;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.text.resolve(this.original).getString());
        int numberWidth = Minecraft.m_91087_().f_91062_.m_92895_(SingleStatDisplayBoolean.getText(this.compareToValue).getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        return this.hasValueItemStack(original) || this.hasValueItemStack(compareTo);
    }

    public abstract boolean getValueItemStack(ItemStack var1);

    public abstract boolean hasValueItemStack(ItemStack var1);

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        double min = Math.min(this.minValue, Math.min(this.oldValue, this.compareToValue));
        double max = Math.max(this.maxValue, Math.max(this.oldValue, this.compareToValue));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        SingleStatDisplayBoolean.drawTextureWithEdge(drawContext, this.texture, this.m_252754_(), this.m_252907_(), 339, 6, 51, 19, this.f_93618_, this.f_93619_, 512, 512, 2);
        this.textWidget.m_252865_(this.m_252754_() + 3);
        this.textWidget.m_253211_(this.m_252907_() + 3);
        this.textWidget.m_93674_(this.f_93618_ - 25);
        this.statBar.m_252865_(this.m_252754_() + 2);
        this.statBar.m_253211_(this.m_252907_() + 15);
        this.statBar.m_93674_(this.f_93618_ - 4);
        this.statBar.setHeight(1);
        if (this.oldValue < this.compareToValue) {
            this.statBar.setPrimary((this.oldValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((this.compareToValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (this.oldValue == this.compareToValue) {
            this.currentValue.m_252865_(this.m_252754_() - 3);
            this.currentValue.m_253211_(this.m_252907_() + 5);
            this.currentValue.m_93674_(this.m_5711_());
            this.currentValue.setText((Component)Component.m_237113_((String)(SingleStatDisplayBoolean.getText(this.oldValue).getString() + this.postfix.getString())));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.currentValue.m_88315_(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.m_252865_(this.m_252754_() - 3);
            this.compareValue.m_253211_(this.m_252907_() + 5);
            this.compareValue.m_93674_(this.m_5711_());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText((Component)Component.m_237113_((String)(SingleStatDisplayBoolean.getText(this.compareToValue).getString() + this.postfix.getString())));
            this.compareValue.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.m_88315_(drawContext, mouseX, mouseY, delta);
        this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    public static Component getText(double value) {
        return SingleStatDisplayBoolean.getText(value > 0.0);
    }

    public static Component getText(boolean value) {
        if (value) {
            return Component.m_237115_((String)"miapi.ui.boolean.true");
        }
        return Component.m_237115_((String)"miapi.ui.boolean.false");
    }
}

