/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.config.MiapiConfig;

@OnlyIn(value=Dist.CLIENT)
public abstract class SingleStatDisplayDouble
extends InteractAbleWidget
implements SingleStatDisplay,
Renderable {
    public ResourceLocation texture = CraftingScreen.BACKGROUND_TEXTURE;
    public ItemStack original = ItemStack.f_41583_;
    public ItemStack compareTo = ItemStack.f_41583_;
    public StatBar statBar;
    public ScrollingTextWidget currentValue;
    public ScrollingTextWidget compareValue;
    public ScrollingTextWidget centerValue;
    public ScrollingTextWidget textWidget;
    public double maxValue = 100.0;
    public double minValue = 0.0;
    public DecimalFormat modifierFormat;
    public StatListWidget.TextGetter text;
    public StatListWidget.TextGetter hover;
    public HoverDescription hoverDescription;
    public Component postfix = Component.m_130674_((String)"");
    public boolean inverse = false;
    double oldValue = 0.0;
    double compareToValue = 0.0;

    protected SingleStatDisplayDouble(int x, int y, int width, int height, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.text = title;
        this.hover = hover;
        this.textWidget = new ScrollingTextWidget(x, y, 80, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.currentValue = new ScrollingTextWidget(x, y, 50, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.centerValue = new ScrollingTextWidget(x, y, 70, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.centerValue.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.compareValue = new ScrollingTextWidget(x, y, 70, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
        this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
        this.statBar = new StatBar(0, 0, width, 1, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0));
        this.modifierFormat = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        this.hoverDescription = new HoverDescription(x, y, List.of());
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public int getRed() {
        if (this.inverse) {
            return MiapiConfig.INSTANCE.client.guiColors.green.argb();
        }
        return MiapiConfig.INSTANCE.client.guiColors.red.argb();
    }

    public int getGreen() {
        if (this.inverse) {
            return MiapiConfig.INSTANCE.client.guiColors.red.argb();
        }
        return MiapiConfig.INSTANCE.client.guiColors.green.argb();
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        ItemStack mainStack = compareTo.m_41619_() ? original : compareTo;
        this.original = original;
        this.compareTo = compareTo;
        this.compareToValue = this.getValue(compareTo);
        this.oldValue = this.getValue(original);
        this.textWidget.setText(this.text.resolve(mainStack));
        this.hoverDescription.setText(this.hover.resolve(mainStack));
        this.compareValue.setText(Component.m_130674_((String)this.modifierFormat.format(this.compareToValue)));
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text.resolve(original));
        int numberWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.compareValue.getText());
        int size = Math.min(3, Math.max(1, (textWidth + numberWidth) / 47));
        this.m_93674_(51 * size);
        return true;
    }

    @Override
    public int getHeightDesired() {
        return 19;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.text.resolve(this.original).getString());
        int numberWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.compareValue.getText().getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    public abstract double getValue(ItemStack var1);

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        double min = Math.min(this.minValue, Math.min(this.oldValue, this.compareToValue));
        double max = Math.max(this.maxValue, Math.max(this.oldValue, this.compareToValue));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        SingleStatDisplayDouble.drawTextureWithEdge(drawContext, this.texture, this.m_252754_(), this.m_252907_(), 339, 6, 51, 19, this.f_93618_, this.f_93619_, 512, 512, 2);
        this.textWidget.m_252865_(this.m_252754_() + 3);
        this.textWidget.m_253211_(this.m_252907_() + 3);
        this.textWidget.m_93674_(this.f_93618_ - 25);
        this.statBar.m_252865_(this.m_252754_() + 2);
        this.statBar.m_253211_(this.m_252907_() + 15);
        this.statBar.m_93674_(this.f_93618_ - 4);
        this.statBar.setHeight(1);
        if (this.oldValue < this.compareToValue) {
            this.statBar.setPrimary((this.oldValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((this.compareToValue - min) / (max - min), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (this.oldValue == this.compareToValue) {
            this.currentValue.m_252865_(this.m_252754_() - 3);
            this.currentValue.m_253211_(this.m_252907_() + 5);
            this.currentValue.m_93674_(this.m_5711_());
            this.currentValue.setText((Component)Component.m_237113_((String)(this.modifierFormat.format(this.oldValue) + this.postfix.getString())));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.currentValue.m_88315_(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.m_252865_(this.m_252754_() - 3);
            this.compareValue.m_253211_(this.m_252907_() + 5);
            this.compareValue.m_93674_(this.m_5711_());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText((Component)Component.m_237113_((String)(Component.m_130674_((String)this.modifierFormat.format(this.compareToValue)).getString() + this.postfix.getString())));
            this.compareValue.m_88315_(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.m_88315_(drawContext, mouseX, mouseY, delta);
        this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        Component text1;
        if (this.m_5953_(mouseX, mouseY) && !(text1 = this.hover.resolve(this.compareTo)).getString().isEmpty()) {
            List texts = Arrays.stream(text1.getString().split("\n")).map(a -> Component.m_237113_((String)a)).collect(Collectors.toList());
            drawContext.m_280666_(Minecraft.m_91087_().f_91062_, texts, mouseX, mouseY);
        }
    }

    @Override
    public InteractAbleWidget getHoverWidget() {
        return null;
    }

    public static interface StatReaderHelper {
        public double getValue(ItemStack var1);

        public boolean hasValue(ItemStack var1);
    }
}

