/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.BoxList;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.statdisplay.AttributeSingleDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.ComplexBooleanStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.DpsStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.MiningLevelStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SinglePropertyStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.item.modular.CustomDrawTimeItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.AirDragProperty;
import smartin.miapi.modules.properties.ArmorPenProperty;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.BlockProperty;
import smartin.miapi.modules.properties.CanWalkOnSnow;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.ExhaustionProperty;
import smartin.miapi.modules.properties.FireProof;
import smartin.miapi.modules.properties.FlexibilityProperty;
import smartin.miapi.modules.properties.FortuneProperty;
import smartin.miapi.modules.properties.FracturingProperty;
import smartin.miapi.modules.properties.HealthPercentDamage;
import smartin.miapi.modules.properties.ImmolateProperty;
import smartin.miapi.modules.properties.IsCrossbowShootAble;
import smartin.miapi.modules.properties.IsPiglinGold;
import smartin.miapi.modules.properties.LeechingProperty;
import smartin.miapi.modules.properties.LuminousLearningProperty;
import smartin.miapi.modules.properties.MendingProperty;
import smartin.miapi.modules.properties.NemesisProperty;
import smartin.miapi.modules.properties.PillagesGuard;
import smartin.miapi.modules.properties.RapidfireCrossbowProperty;
import smartin.miapi.modules.properties.StepCancelingProperty;
import smartin.miapi.modules.properties.WaterDragProperty;
import smartin.miapi.modules.properties.WaterGravityProperty;
import smartin.miapi.modules.properties.damage_boosts.AquaticDamage;
import smartin.miapi.modules.properties.damage_boosts.IllagerBane;
import smartin.miapi.modules.properties.damage_boosts.SmiteDamage;
import smartin.miapi.modules.properties.damage_boosts.SpiderDamage;
import smartin.miapi.modules.properties.util.GuiWidgetSupplier;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class StatListWidget
extends InteractAbleWidget {
    private static final List<InteractAbleWidget> statDisplays = new ArrayList<InteractAbleWidget>();
    private static final List<StatWidgetSupplier> statWidgetSupplier = new ArrayList<StatWidgetSupplier>();
    public static final Map<String, JsonConverter> jsonConverterMap = new HashMap<String, JsonConverter>();
    private final BoxList boxList;
    private TransformableWidget transformableWidget;
    private TransformableWidget hoverText;
    private ItemStack original = ItemStack.f_41583_;
    private ItemStack compareTo = ItemStack.f_41583_;

    public static void onReload() {
        statDisplays.clear();
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(NemesisProperty.property).setMin(0.0).setMax(1.0).setTranslationKey(NemesisProperty.KEY).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(Attributes.f_22281_).setTranslationKey("damage").setDefault(1.0).setMax(13.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(Attributes.f_22283_).setTranslationKey("attack_speed").setDefault(4.0).setMax(4.0).build());
        StatListWidget.addStatDisplay(new DpsStatDisplay());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.BACK_STAB).setTranslationKey("back_stab").setDefault(1.0).setFormat("##.#").setMax(5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.SHIELD_BREAK).setTranslationKey("shield_break").setDefault(0.0).setFormat("##.#").setMax(5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.REACH).setTranslationKey("reach").setDefault(0.0).setFormat("##.##").setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ATTACK_RANGE).setTranslationKey("attack_range").setDefault(0.0).setFormat("##.##").setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_DAMAGE).setTranslationKey("projectile_damage").setFormat("##.##").setDefault(0.0).setMax(10.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_SPEED).setTranslationKey("projectile_speed").setFormat("##.##").setDefault(0.0).setMin(-3.0).setMax(10.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_ACCURACY).setTranslationKey("projectile_accuracy").setFormat("##.##").setDefault(0.0).setMin(-2.0).setMax(2.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_PIERCING).setTranslationKey("projectile_piercing").setFormat("##.##").setMax(10.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_CRIT_MULTIPLIER).setTranslationKey("projectile_crit_multiplier").setFormat("##.##").setMax(10.0).build());
        StatListWidget.addStatDisplay(MiningLevelStatDisplay.builder("pickaxe").setAttribute(AttributeRegistry.MINING_SPEED_PICKAXE).build());
        StatListWidget.addStatDisplay(MiningLevelStatDisplay.builder("axe").setAttribute(AttributeRegistry.MINING_SPEED_AXE).build());
        StatListWidget.addStatDisplay(MiningLevelStatDisplay.builder("shovel").setAttribute(AttributeRegistry.MINING_SPEED_SHOVEL).build());
        StatListWidget.addStatDisplay(MiningLevelStatDisplay.builder("hoe").setAttribute(AttributeRegistry.MINING_SPEED_HOE).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(FlexibilityProperty.property).setTranslationKey("flexibility").setMax(10.0).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(HealthPercentDamage.property).setMax(50.0).setTranslationKey("healthPercent").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ArmorPenProperty.property).setMin(-20.0).setMax(50.0).setTranslationKey("armor_pen").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(BlockProperty.property).setMax(50.0).setTranslationKey("blocking").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(AirDragProperty.property).setMax(1.0).setTranslationKey("air_drag").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(WaterDragProperty.property).setMax(1.0).setTranslationKey("water_drag").build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.BOW_DRAW_TIME).setMax(100.0).setMin(1.0).setDefault(20.0).setValueGetter(stack -> {
            Item patt8983$temp = stack.m_41720_();
            if (patt8983$temp instanceof CustomDrawTimeItem) {
                CustomDrawTimeItem customDrawTimeItem = (CustomDrawTimeItem)patt8983$temp;
                return customDrawTimeItem.getActualDrawTime(stack);
            }
            if (stack.m_41720_() instanceof CrossbowItem) {
                return 25.0 - AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.BOW_DRAW_TIME);
            }
            return 20.0 - AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.BOW_DRAW_TIME);
        }).setTranslationKey("bow_draw_time").inverseNumber(true).setFormat("##.##").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(RapidfireCrossbowProperty.property).setMax(3.0).setFormat("##").setTranslationKey(RapidfireCrossbowProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(DurabilityProperty.property).setMax(2000.0).setFormat("##").setTranslationKey("durability").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(FracturingProperty.property).setMax(50.0).setTranslationKey("fracturing").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(FortuneProperty.property).setMax(5.0).setTranslationKey("fortune").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(MendingProperty.property).setMax(1.0).setTranslationKey("mending").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ImmolateProperty.property).setMax(4.0).setTranslationKey("immolate").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(LeechingProperty.property).setMax(2.0).setTranslationKey("leeching").build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(Attributes.f_22284_).setTranslationKey("armor").setMax(8.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PROJECTILE_ARMOR).setTranslationKey("projectile_armor").setMax(8.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(Attributes.f_22285_).setTranslationKey("armor_toughness").setMax(3.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(Attributes.f_22278_).setTranslationKey("knockback_resistance").setMax(1.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.SWIM_SPEED).setTranslationKey("swim_speed").setMax(1.5).setDefault(1.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_GLIDE_EFFICIENCY).setTranslationKey("elytra_glide").setMax(20.0).setMin(-20.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_TURN_EFFICIENCY).setTranslationKey("elytra_turn").setMax(20.0).setMin(-20.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.ELYTRA_ROCKET_EFFICIENCY).setTranslationKey("rocket_efficiency").setMax(5.0).setMin(-5.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.PLAYER_ITEM_USE_MOVEMENT_SPEED).setTranslationKey("player_item_use_speed").setMax(0.0).inverseNumber(true).setMin(-1.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.CRITICAL_DAMAGE).setTranslationKey("crit_damage").setMax(3.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(AttributeRegistry.CRITICAL_CHANCE).setTranslationKey("crit_chance").setMax(1.0).setMin(0.0).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(IllagerBane.property).setMax(3.0).setFormat("##.#").setTranslationKey("illagerBane").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(LuminousLearningProperty.property).setMax(2.0).setFormat("##.#").setTranslationKey("luminiousLearning").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(ExhaustionProperty.property).setMax(50.0).setFormat("##.#").setTranslationKey("food_exhaustion").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(WaterGravityProperty.property).setMax(100.0).setFormat("##.#").setTranslationKey("water_gravity").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(AquaticDamage.property).setMax(5.0).setTranslationKey("aquatic_damage").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(SpiderDamage.property).setMax(5.0).setTranslationKey("spider_damage").build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(SmiteDamage.property).setMax(5.0).setTranslationKey("smite_damage").build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(CanWalkOnSnow.property).setTranslationKey("canWalkOnSnow").build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(FireProof.property).setTranslationKey("fireProof").build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(IsCrossbowShootAble.property).setTranslationKey("crossbowAmmunition").build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(IsPiglinGold.property).setTranslationKey("isPiglinGold").build());
        StatListWidget.addStatDisplay(ComplexBooleanStatDisplay.builder(StepCancelingProperty.property).setTranslationKey(StepCancelingProperty.KEY).build());
        StatListWidget.addStatDisplay(SinglePropertyStatDisplay.builder(PillagesGuard.property).setMax(3.0).setFormat("##.#").setTranslationKey("pillagerGuard").setHoverDescription(stack -> {
            double value = PillagesGuard.valueRemap(PillagesGuard.property.getValueSafe(stack));
            value = (double)Math.round((1.0 - value) * 1000.0) / 10.0;
            return Component.m_237110_((String)"miapi.stat.pillagerGuard.description", (Object[])new Object[]{value});
        }).build());
        AttributeSingleDisplay.attributesWithDisplay.add(AttributeRegistry.MINING_SPEED_AXE);
        AttributeSingleDisplay.attributesWithDisplay.add(AttributeRegistry.MINING_SPEED_PICKAXE);
        AttributeSingleDisplay.attributesWithDisplay.add(AttributeRegistry.MINING_SPEED_HOE);
        AttributeSingleDisplay.attributesWithDisplay.add(AttributeRegistry.MINING_SPEED_SHOVEL);
        AttributeSingleDisplay.attributesWithDisplay.add(AttributeRegistry.ARMOR_CRUSHING);
        RegistryInventory.moduleProperties.getFlatMap().values().stream().filter(StatWidgetSupplier.class::isInstance).map(StatWidgetSupplier.class::cast).filter(statWidgetSupplier::contains).forEach(statWidgetSupplier::add);
    }

    public static void reloadEnd() {
        BuiltInRegistries.f_256951_.forEach(entityAttribute -> {
            if (!AttributeSingleDisplay.attributesWithDisplay.contains(entityAttribute)) {
                StatListWidget.addStatDisplay(AttributeSingleDisplay.builder(entityAttribute).build());
            }
        });
    }

    public StatListWidget(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"miapi.module.statdisplay"));
        this.transformableWidget = new TransformableWidget(x, y, width, height, (Component)Component.m_237119_());
        this.boxList = new BoxList(x, y, width, height, (Component)Component.m_237119_(), new ArrayList<AbstractWidget>());
        ScrollList list = new ScrollList(x, y, width, height, List.of(this.boxList));
        list.altDesign = true;
        list.alwaysEnableScrollbar = true;
        this.transformableWidget.addChild(list);
        this.transformableWidget.rawProjection = new Matrix4f();
        this.addChild(this.transformableWidget);
        this.hoverText = new TransformableWidget(x, y, width, height, (Component)Component.m_237119_());
        this.hoverText.rawProjection = new Matrix4f().scale(0.667f, 0.667f, 0.667f);
        this.addChild(this.hoverText);
    }

    public static MutableComponent statTranslation(String statName) {
        return Component.m_237115_((String)("miapi.stat." + statName));
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.m_88315_(drawContext, mouseX, mouseY, delta);
        Vector4f vector4f = this.transformableWidget.transFormMousePos(mouseX, mouseY);
        InteractAbleWidget hoverDisplay = null;
        for (GuiEventListener children : this.boxList.children()) {
            SingleStatDisplay widget;
            InteractAbleWidget ableWidget;
            if (!children.m_5953_((double)vector4f.x(), (double)vector4f.y()) || !(children instanceof SingleStatDisplay) || (ableWidget = (widget = (SingleStatDisplay)children).getHoverWidget()) == null) continue;
            hoverDisplay = ableWidget;
        }
        if (hoverDisplay != null && this.m_5953_(mouseX, mouseY)) {
            float scale = 1.0f;
            hoverDisplay.m_252865_((int)((float)(mouseX + 5) * (1.0f / scale)));
            hoverDisplay.m_253211_((int)(((float)mouseY - (float)(hoverDisplay.m_93694_() / 2) * scale) * (1.0f / scale)));
            this.hoverText.renderWidget(hoverDisplay, drawContext, mouseX, mouseY, delta);
        }
    }

    private <T extends InteractAbleWidget> void update() {
        StatListWidget.setAttributeCaches(this.original, this.compareTo);
        this.boxList.setWidgets(StatListWidget.collectWidgets(this.original, this.compareTo), 0);
    }

    public static void setAttributeCaches(ItemStack original, ItemStack compareTo) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            Multimap oldAttr = original.m_41638_(equipmentSlot);
            Multimap compAttr = compareTo.m_41638_(equipmentSlot);
            AttributeSingleDisplay.oldItemCache.put(equipmentSlot, (Multimap<Attribute, AttributeModifier>)oldAttr);
            AttributeSingleDisplay.compareItemCache.put(equipmentSlot, (Multimap<Attribute, AttributeModifier>)compAttr);
        }
    }

    public static <T extends InteractAbleWidget> List<InteractAbleWidget> collectWidgets(ItemStack original, ItemStack compareTo) {
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        for (StatWidgetSupplier supplier : statWidgetSupplier) {
            List statWidgets = supplier.currentList(original, compareTo);
            for (InteractAbleWidget statDisplay : statWidgets) {
                if (!((SingleStatDisplay)((Object)statDisplay)).shouldRender(original, compareTo)) continue;
                statDisplay.setHeight(((SingleStatDisplay)((Object)statDisplay)).getHeightDesired());
                statDisplay.m_93674_(((SingleStatDisplay)((Object)statDisplay)).getWidthDesired());
                widgets.add(statDisplay);
            }
        }
        for (InteractAbleWidget statDisplay : statDisplays) {
            SingleStatDisplay singleStatDisplay;
            if (!(statDisplay instanceof SingleStatDisplay) || !(singleStatDisplay = (SingleStatDisplay)((Object)statDisplay)).shouldRender(original, compareTo)) continue;
            statDisplay.setHeight(singleStatDisplay.getHeightDesired());
            statDisplay.m_93674_(singleStatDisplay.getWidthDesired());
            widgets.add(statDisplay);
        }
        ArrayList<InteractAbleWidget> sortedWidgets = new ArrayList<InteractAbleWidget>();
        int shortSize = 80;
        InteractAbleWidget buffered = null;
        for (InteractAbleWidget widget : widgets) {
            if (widget.m_5711_() <= shortSize) {
                if (buffered == null) {
                    buffered = widget;
                    continue;
                }
                sortedWidgets.add(buffered);
                sortedWidgets.add(widget);
                buffered = null;
                continue;
            }
            sortedWidgets.add(widget);
        }
        if (buffered != null) {
            sortedWidgets.add(buffered);
        }
        return sortedWidgets;
    }

    public static <T extends InteractAbleWidget> void addStatDisplay(T statDisplay) {
        statDisplays.add(statDisplay);
    }

    public static <T extends InteractAbleWidget> void addStatDisplay(T ... statDisplay) {
        statDisplays.addAll(Arrays.asList(statDisplay));
    }

    public static void addStatDisplaySupplier(StatWidgetSupplier supplier) {
        statWidgetSupplier.add(supplier);
    }

    public void setOriginal(ItemStack original) {
        this.original = original;
        this.update();
    }

    public void setCompareTo(ItemStack compareTo) {
        this.compareTo = compareTo;
        this.update();
    }

    public void setItemsOriginal(ItemStack original, ItemStack compareTo) {
        this.original = original;
        this.compareTo = compareTo;
        this.update();
    }

    static {
        statWidgetSupplier.add(new StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                HashSet<GuiWidgetSupplier> suppliers = new HashSet<GuiWidgetSupplier>();
                suppliers.addAll(ItemModule.getModules(original).getPropertiesMerged().keySet().stream().filter(property -> property instanceof GuiWidgetSupplier).map(property -> (GuiWidgetSupplier)((Object)property)).toList());
                suppliers.addAll(ItemModule.getModules(compareTo).getPropertiesMerged().keySet().stream().filter(property -> property instanceof GuiWidgetSupplier).map(property -> (GuiWidgetSupplier)((Object)property)).toList());
                return suppliers.stream().map(guiWidgetSupplier -> new JsonStatDisplay(guiWidgetSupplier.getTitle(), guiWidgetSupplier.getDescription(), guiWidgetSupplier.getStatReader(), guiWidgetSupplier.getMinValue(), guiWidgetSupplier.getMaxValue())).toList();
            }
        });
    }

    public static interface TextGetter {
        public Component resolve(ItemStack var1);
    }

    public static interface StatWidgetSupplier {
        public <T extends InteractAbleWidget> List<T> currentList(ItemStack var1, ItemStack var2);
    }

    public static interface JsonConverter<T extends InteractAbleWidget> {
        public T fromJson(JsonElement var1, SingleStatDisplayDouble.StatReaderHelper var2);
    }

    public static interface MultiTextGetter {
        public List<Component> resolve(ItemStack var1);
    }
}

