/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.ModelTransformer;
import smartin.miapi.client.renderer.TrimRenderer;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.EmissiveProperty;
import smartin.miapi.modules.properties.GlintProperty;
import smartin.miapi.registries.RegistryInventory;

public class BakedMiapiModel
implements MiapiModel {
    ItemModule.ModuleInstance instance;
    BakedModel model;
    Matrix4f modelMatrix;
    ModelHolder modelHolder;
    RandomSource random = RandomSource.m_216327_();
    float[] colors;
    GlintProperty.GlintSettings settings;
    int skyLight;
    int blockLight;

    public BakedMiapiModel(ModelHolder holder, ItemModule.ModuleInstance moduleInstance, ItemStack stack) {
        this.modelHolder = holder;
        this.instance = moduleInstance;
        Color color = holder.colorProvider().getVertexColor();
        this.colors = new float[]{color.redAsFloat(), color.greenAsFloat(), color.blueAsFloat()};
        this.modelMatrix = holder.matrix4f();
        this.model = holder.model();
        this.settings = GlintProperty.property.getGlintSettings(moduleInstance, stack);
        if (holder.lightValues() != null) {
            this.skyLight = holder.lightValues()[0];
            this.blockLight = holder.lightValues()[1];
        } else {
            this.skyLight = -1;
            this.blockLight = -1;
        }
        int[] propertyLight = EmissiveProperty.getLightValues(moduleInstance);
        int propertySky = propertyLight[0];
        int propertyBlock = propertyLight[1];
        if (propertySky > this.skyLight) {
            this.skyLight = propertySky;
        }
        if (propertyBlock > this.blockLight) {
            this.blockLight = propertyBlock;
        }
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int packedLight, int overlay) {
        ArmorMaterial armorMaterial;
        assert (Minecraft.m_91087_().f_91073_ != null);
        matrices.m_85836_();
        int sky = LightTexture.m_109894_((int)packedLight);
        int block = LightTexture.m_109883_((int)packedLight);
        if (this.skyLight != -1) {
            sky = this.skyLight;
        }
        if (this.blockLight != -1) {
            block = this.blockLight;
        }
        int light = LightTexture.m_109885_((int)block, (int)sky);
        Transform.applyPosition(matrices, this.modelMatrix);
        BakedModel currentModel = this.resolve(this.model, stack, entity, light);
        Minecraft.m_91087_().f_91073_.m_46473_().m_6180_("BakedModel");
        for (Direction dir : Direction.values()) {
            currentModel.m_213637_(null, dir, RandomSource.m_216327_()).forEach(quad -> {
                VertexConsumer vertexConsumer = this.modelHolder.colorProvider().getConsumer(vertexConsumers, quad.m_173410_(), stack, this.instance, transformationMode);
                vertexConsumer.m_85987_(matrices.m_85850_(), quad, this.colors[0], this.colors[1], this.colors[2], light, overlay);
                if (stack.m_41790_()) {
                    VertexConsumer altConsumer = vertexConsumers.m_6299_(RegistryInventory.Client.modularItemGlint);
                    Color glintColor = this.settings.getColor();
                    altConsumer.m_85987_(matrices.m_85850_(), quad, glintColor.redAsFloat(), glintColor.greenAsFloat(), glintColor.blueAsFloat(), light, overlay);
                }
            });
        }
        Minecraft.m_91087_().f_91073_.m_46473_().m_7238_();
        Minecraft.m_91087_().f_91073_.m_46473_().m_6180_("TrimModel");
        ArmorTrim trim = ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)stack).orElse(null);
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            v0 = armorItem.m_40401_();
        } else {
            v0 = armorMaterial = null;
        }
        if (trim != null && armorMaterial != null && !this.modelHolder.trimMode().equals((Object)TrimRenderer.TrimMode.NONE)) {
            ModelTransformer.getRescale(currentModel, this.random).forEach(quad -> TrimRenderer.renderTrims(matrices, quad, this.modelHolder.trimMode(), light, vertexConsumers, armorMaterial, stack));
        }
        Minecraft.m_91087_().f_91073_.m_46473_().m_7238_();
        Minecraft.m_91087_().f_91073_.m_46473_().m_6180_("EntityModel");
        if (this.modelHolder.entityRendering()) {
            ModelTransformer.getInverse(currentModel, this.random).forEach(quad -> {
                VertexConsumer vertexConsumer = this.modelHolder.colorProvider().getConsumer(vertexConsumers, quad.m_173410_(), stack, this.instance, transformationMode);
                vertexConsumer.m_85987_(matrices.m_85850_(), quad, this.colors[0], this.colors[1], this.colors[2], light, overlay);
                if (stack.m_41790_()) {
                    VertexConsumer altConsumer = vertexConsumers.m_6299_(RegistryInventory.Client.modularItemGlint);
                    Color glintColor = this.settings.getColor();
                    altConsumer.m_85987_(matrices.m_85850_(), quad, glintColor.redAsFloat(), glintColor.greenAsFloat(), glintColor.blueAsFloat(), light, overlay);
                }
            });
        }
        Minecraft.m_91087_().f_91073_.m_46473_().m_7238_();
        matrices.m_85849_();
    }

    public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable LivingEntity entity, int light) {
        if (model.m_7343_() != null && !model.m_7343_().equals(ItemOverrides.f_111734_)) {
            BakedModel override = model.m_7343_().m_173464_(model, stack, Minecraft.m_91087_().f_91073_, entity, light);
            if (model != null) {
                model = override;
            }
        }
        return model;
    }
}

