/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.ConduitRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.item.modular.Transform;

public class ConduitRendererEntity
implements MiapiModel {
    Transform transform;
    ConduitRenderer renderer;
    ConduitBlockEntity conduitBlockEntity;
    private final ModelPart conduitEye;
    private final ModelPart conduitWind;
    private final ModelPart conduitShell;
    private final ModelPart conduit;

    public ConduitRendererEntity(Transform transform) {
        this.transform = transform;
        this.conduitBlockEntity = new ConduitBlockEntity(BlockPos.f_121853_, Blocks.f_50569_.m_49966_());
        this.conduitEye = ConduitRendererEntity.getEyeTexturedModelData().m_171564_();
        this.conduitWind = ConduitRendererEntity.getWindTexturedModelData().m_171564_();
        this.conduitShell = ConduitRendererEntity.getShellTexturedModelData().m_171564_();
        this.conduit = ConduitRendererEntity.getPlainTexturedModelData().m_171564_();
    }

    public static LayerDefinition getEyeTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)16, (int)16);
    }

    public static LayerDefinition getWindTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("wind", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    public static LayerDefinition getShellTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)32, (int)16);
    }

    public static LayerDefinition getPlainTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)32, (int)16);
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float f, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        f = 0.0f;
        float h = this.conduitBlockEntity.m_59197_(f) * 57.295776f;
        float g = (float)this.conduitBlockEntity.f_59183_ + f;
        float k = Mth.m_14031_((float)(g * 0.1f)) / 2.0f + 0.5f;
        k += k * k;
        matrices.m_85836_();
        this.transform.applyPosition(matrices);
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.3f + k * 0.2f, 0.5f);
        Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
        matrices.m_252781_(new Quaternionf().rotationAxis(h * ((float)Math.PI / 180), (Vector3fc)vector3f));
        this.conduit.m_104301_(matrices, ConduitRenderer.f_112379_.m_119194_(vertexConsumers, RenderType::m_110458_), light, overlay);
        matrices.m_85849_();
        int l = this.conduitBlockEntity.f_59183_ / 66 % 3;
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.5f, 0.5f);
        if (l == 1) {
            matrices.m_252781_(new Quaternionf().rotationX(1.5707964f));
        } else if (l == 2) {
            matrices.m_252781_(new Quaternionf().rotationZ(1.5707964f));
        }
        VertexConsumer vertexConsumer2 = (l == 1 ? ConduitRenderer.f_112381_ : ConduitRenderer.f_112380_).m_119194_(vertexConsumers, RenderType::m_110458_);
        this.conduitWind.m_104301_(matrices, vertexConsumer2, light, overlay);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.5f, 0.5f);
        matrices.m_85841_(0.875f, 0.875f, 0.875f);
        matrices.m_252781_(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.3f + k * 0.2f, 0.5f);
        matrices.m_85841_(0.5f, 0.5f, 0.5f);
        Matrix4f matrix4f = matrices.m_85850_().m_252922_();
        float dir = matrix4f.getTranslation(new Vector3f()).x() > 0.0f ? 1.0f : -1.0f;
        matrix4f.rotate((Quaternionfc)matrix4f.getUnnormalizedRotation(new Quaternionf()).invert());
        matrix4f.rotate((float)Math.PI, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        this.conduitEye.m_104301_(matrices, (this.conduitBlockEntity.m_59217_() ? ConduitRenderer.f_112382_ : ConduitRenderer.f_112383_).m_119194_(vertexConsumers, RenderType::m_110458_), 0xF000F0, overlay);
        matrices.m_85849_();
        matrices.m_85849_();
    }
}

