/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModuleModel;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.registries.RegistryInventory;

public class MiapiItemModel
implements MiapiModel {
    public static List<ModelSupplier> modelSuppliers = new ArrayList<ModelSupplier>();
    public static List<ModelTransformer> modelTransformers = new ArrayList<ModelTransformer>();
    public final ItemStack stack;
    public final ModuleModel rootModel;
    private static final String CACHE_KEY = "miapi_model_rework";

    @Nullable
    public static MiapiItemModel getItemModel(ItemStack stack) {
        return (MiapiItemModel)ModularItemCache.getRaw(stack, CACHE_KEY);
    }

    private MiapiItemModel(ItemStack stack) {
        this.stack = stack;
        if (!(stack.m_41720_() instanceof VisualModularItem)) {
            this.rootModel = null;
            throw new RuntimeException("Can only make MiapiModel for Modular Items");
        }
        this.rootModel = new ModuleModel(ItemModule.getModules(stack), stack);
    }

    public void render(PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.render(null, matrices, mode, tickDelta, vertexConsumers, light, overlay);
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        this.render(null, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
    }

    public void render(String modelType, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.render(modelType, this.stack, matrices, mode, tickDelta, vertexConsumers, null, light, overlay);
    }

    public void render(String modelType, ItemStack stack, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        if (ReloadEvents.isInReload()) {
            return;
        }
        Minecraft.m_91087_().f_91073_.m_46473_().m_6180_("modular_item");
        matrices.m_85836_();
        for (ModelTransformer transformer : modelTransformers) {
            matrices = transformer.transform(matrices, stack, mode, modelType, tickDelta);
        }
        if (entity == null) {
            entity = Minecraft.m_91087_().f_91074_;
        }
        RegistryInventory.Client.glintShader.m_173356_("ModelMat").m_5679_(new Matrix4f((Matrix4fc)matrices.m_85850_().m_252922_()));
        this.rootModel.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
        matrices.m_85849_();
        Minecraft.m_91087_().f_91073_.m_46473_().m_7238_();
    }

    @Override
    @Nullable
    public Matrix4f subModuleMatrix() {
        return null;
    }

    static {
        ModularItemCache.setSupplier(CACHE_KEY, MiapiItemModel::new);
    }

    public static interface ModelTransformer {
        public PoseStack transform(PoseStack var1, ItemStack var2, ItemDisplayContext var3, String var4, float var5);
    }

    public static interface ModelSupplier {
        public List<MiapiModel> getModels(@Nullable String var1, ItemModule.ModuleInstance var2, ItemStack var3);
    }
}

