/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;

public class ModelTransformer {
    private static Map<BakedModel, List<BakedQuad>> inverseMap = new WeakHashMap<BakedModel, List<BakedQuad>>();
    private static Map<BakedModel, List<BakedQuad>> reScaledMap = new WeakHashMap<BakedModel, List<BakedQuad>>();
    private static Map<BakedModel, List<BakedQuad>> inversedRescaledMap = new WeakHashMap<BakedModel, List<BakedQuad>>();

    public static void clearCaches() {
        inverseMap.clear();
        reScaledMap.clear();
        inversedRescaledMap.clear();
    }

    public static List<BakedQuad> getInverse(BakedModel bakedModel, RandomSource random) {
        return inverseMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.m_213637_(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> redoneQuads.add(new BakedQuad(ModelTransformer.inverse(bakedQuad.m_111303_()), bakedQuad.m_111305_(), bakedQuad.m_111306_(), bakedQuad.m_173410_(), bakedQuad.m_111307_())));
            return redoneQuads;
        });
    }

    public static List<BakedQuad> getRescale(BakedModel bakedModel, RandomSource random) {
        return reScaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.m_213637_(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.m_173410_().m_118409_();
                float uScale = 1.0f / (bakedQuad.m_173410_().m_118410_() - bakedQuad.m_173410_().m_118409_());
                float vStart = bakedQuad.m_173410_().m_118411_();
                float vScale = 1.0f / (bakedQuad.m_173410_().m_118412_() - bakedQuad.m_173410_().m_118411_());
                redoneQuads.add(new BakedQuad(ModelTransformer.rescale(bakedQuad.m_111303_(), uStart, uScale, vStart, vScale), bakedQuad.m_111305_(), bakedQuad.m_111306_(), bakedQuad.m_173410_(), bakedQuad.m_111307_()));
            });
            return redoneQuads;
        });
    }

    public static List<BakedQuad> getRescaleInverse(BakedModel bakedModel, RandomSource random) {
        return inversedRescaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (Direction direction : Direction.values()) {
                rawQuads.addAll(model.m_213637_(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.m_173410_().m_118409_();
                float uScale = 1.0f / (bakedQuad.m_173410_().m_118410_() - bakedQuad.m_173410_().m_118409_());
                float vStart = bakedQuad.m_173410_().m_118411_();
                float vScale = 1.0f / (bakedQuad.m_173410_().m_118412_() - bakedQuad.m_173410_().m_118411_());
                redoneQuads.add(new BakedQuad(ModelTransformer.inverse(ModelTransformer.rescale(bakedQuad.m_111303_(), uStart, uScale, vStart, vScale)), bakedQuad.m_111305_(), bakedQuad.m_111306_(), bakedQuad.m_173410_(), bakedQuad.m_111307_()));
            });
            return redoneQuads;
        });
    }

    private static int[] rescale(int[] raw, float uStart, float uScale, float vStart, float vScale) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int i = 0; i < raw.length / 8; ++i) {
            copiedArray[i * 8 + 4] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 4]) - uStart) * uScale);
            copiedArray[i * 8 + 5] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 5]) - vStart) * vScale);
        }
        return copiedArray;
    }

    private static int[] inverse(int[] raw) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int j = 0; j < 8; ++j) {
            copiedArray[0 + j] = raw[16 + j];
            copiedArray[8 + j] = raw[8 + j];
            copiedArray[16 + j] = raw[0 + j];
            copiedArray[24 + j] = raw[24 + j];
        }
        return copiedArray;
    }
}

