/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.SlotProperty;

public class ModuleModel {
    public List<Pair<Matrix4f, MiapiModel>> models;
    public Map<String, List<Pair<Matrix4f, MiapiModel>>> otherModels;
    public final ItemModule.ModuleInstance instance;
    public Map<Integer, ModuleModel> subModuleModels = new HashMap<Integer, ModuleModel>();
    public ItemStack stack;

    public ModuleModel(ItemModule.ModuleInstance instance, ItemStack stack) {
        this.instance = instance;
        this.stack = stack;
        this.models = this.generateModel(null);
        this.otherModels = new HashMap<String, List<Pair<Matrix4f, MiapiModel>>>();
        this.otherModels.put("item", this.models);
    }

    private List<Pair<Matrix4f, MiapiModel>> generateModel(String key) {
        ArrayList<Pair<Matrix4f, MiapiModel>> modelList = new ArrayList<Pair<Matrix4f, MiapiModel>>();
        Transform transform = SlotProperty.getTransformStack(this.instance).get(key).copy();
        Matrix4f matrix4f = Transform.toModelTransformation(transform).toMatrix();
        for (MiapiItemModel.ModelSupplier supplier : MiapiItemModel.modelSuppliers) {
            supplier.getModels(key, this.instance, this.stack).forEach(model -> modelList.add(new Pair((Object)matrix4f, model)));
        }
        return modelList;
    }

    public void render(String modelTypeRaw, ItemStack stack, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        String modelType;
        String string = modelType = modelTypeRaw == null ? "item" : modelTypeRaw;
        if (!this.otherModels.containsKey(modelType)) {
            this.otherModels.put(modelType, this.generateModel(modelType));
        }
        Matrix4f submoduleMatrix = new Matrix4f();
        this.otherModels.get(modelType).forEach(matrix4fMiapiModelPair -> {
            matrices.m_85836_();
            Transform.applyPosition(matrices, (Matrix4f)matrix4fMiapiModelPair.getFirst());
            ((MiapiModel)matrix4fMiapiModelPair.getSecond()).render(matrices, stack, mode, tickDelta, vertexConsumers, entity, light, overlay);
            matrices.m_85849_();
            submoduleMatrix.mul((Matrix4fc)((MiapiModel)matrix4fMiapiModelPair.getSecond()).subModuleMatrix());
        });
        this.instance.subModules.forEach((integer, instance1) -> {
            matrices.m_85836_();
            Transform.applyPosition(matrices, submoduleMatrix);
            ModuleModel subModuleModel = this.subModuleModels.get(integer);
            if (subModuleModel == null) {
                subModuleModel = new ModuleModel((ItemModule.ModuleInstance)instance1, stack);
                this.subModuleModels.put((Integer)integer, subModuleModel);
            }
            subModuleModel.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
            matrices.m_85849_();
        });
    }
}

