/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.texture.SpriteContents;
import smartin.miapi.mixin.client.SpriteContentsAccessor;

public class NativeImageGetter {
    public static Map<SpriteContents, ImageHolder> nativeImageMap = new WeakHashMap<SpriteContents, ImageHolder>();

    public static ImageHolder get(SpriteContents contents) {
        return nativeImageMap.getOrDefault(contents, NativeImageGetter.getFromContents(contents));
    }

    public static ImageHolder getFromContents(SpriteContents contents) {
        ImageHolder imageHolder = new ImageHolder();
        imageHolder.nativeImage = ((SpriteContentsAccessor)contents).getImage();
        imageHolder.height = contents.m_245330_();
        imageHolder.width = contents.m_246492_();
        return imageHolder;
    }

    public static ImageHolder getFromContents(NativeImage contents) {
        ImageHolder imageHolder = new ImageHolder();
        imageHolder.nativeImage = contents;
        imageHolder.height = contents.m_85084_();
        imageHolder.width = contents.m_84982_();
        return imageHolder;
    }

    public static class ImageHolder {
        public NativeImage nativeImage;
        public int x = 0;
        public int y = 0;
        public int width = 16;
        public int height = 16;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public NativeImage.Format getFormat() {
            return this.nativeImage.m_85102_();
        }

        public int getColor(int x, int y) {
            return this.nativeImage.m_84985_(x + this.x, y + this.y);
        }

        public void setColor(int x, int y, int color) {
            this.nativeImage.m_84988_(x + this.x, y + this.y, color);
        }

        public void setLuminance(int x, int y, byte luminance) {
            this.nativeImage.m_166402_(x + this.x, y + this.y, luminance);
        }

        public byte getRed(int x, int y) {
            return this.nativeImage.m_166408_(x + this.x, y + this.y);
        }

        public byte getGreen(int x, int y) {
            return this.nativeImage.m_166415_(x + this.x, y + this.y);
        }

        public byte getBlue(int x, int y) {
            return this.nativeImage.m_166418_(x + this.x, y + this.y);
        }

        public byte getOpacity(int x, int y) {
            return this.nativeImage.m_85087_(x + this.x, y + this.y);
        }
    }
}

