/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.registries.RegistryInventory;

public class CraftAction {
    public final ItemModule toAdd;
    public final Player player;
    public final List<Integer> slotId = new ArrayList<Integer>();
    private ItemStack old;
    private final ModularWorkBenchEntity blockEntity;
    private Container linkedInventory;
    private int inventoryOffset;
    public Map<String, String> data = new ConcurrentHashMap<String, String>();
    public static final List<CraftingEvent> events = new ArrayList<CraftingEvent>();

    public CraftAction(ItemStack old, SlotProperty.ModuleSlot slot, @Nullable ItemModule toAdd, Player player, ModularWorkBenchEntity bench, Map<String, String> data) {
        this.old = ModularItemStackConverter.getModularVersion(old);
        this.toAdd = toAdd;
        ItemModule.ModuleInstance instance = slot.parent;
        if (instance != null) {
            this.slotId.add(slot.id);
            while (instance.parent != null) {
                int slotNumber = SlotProperty.getSlotNumberIn(instance);
                this.slotId.add(slotNumber);
                instance = instance.parent;
            }
        }
        this.player = player;
        this.blockEntity = bench;
        this.data = data;
    }

    public CraftAction(FriendlyByteBuf buf, @Nullable ModularWorkBenchEntity bench) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.slotId.add(buf.readInt());
        }
        String modules = buf.m_130277_();
        this.toAdd = !modules.equals("null") ? RegistryInventory.modules.get(modules) : null;
        this.player = CraftAction.getPlayerFromUuid(buf.m_130259_());
        this.blockEntity = bench;
        int numBuffers = buf.readInt();
        for (int i = 0; i < numBuffers; ++i) {
            String key = buf.m_130277_();
            String value = buf.m_130277_();
            this.data.put(key, value);
        }
    }

    public FriendlyByteBuf toPacket(FriendlyByteBuf buf) {
        buf.writeInt(this.slotId.size());
        for (Integer slot : this.slotId) {
            buf.writeInt(slot.intValue());
        }
        if (this.toAdd != null) {
            buf.m_130070_(this.toAdd.getName());
        } else {
            buf.m_130070_("null");
        }
        buf.m_130077_(this.player.m_20148_());
        buf.writeInt(this.data.size());
        this.data.forEach((key, value) -> {
            buf.m_130070_(key);
            buf.m_130070_(value);
        });
        return buf;
    }

    public void setItem(ItemStack stack) {
        this.old = ModularItemStackConverter.getModularVersion(stack);
    }

    public boolean canPerform() {
        ItemStack crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, buffer) -> {
            if (test.get()) {
                test.set(guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, buffer));
            }
        });
        return test.get();
    }

    public Pair<Map<CraftingProperty, Boolean>, Boolean> fullCanPerform() {
        HashMap map = new HashMap();
        ItemStack crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, dataMap) -> {
            boolean result = guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, dataMap);
            map.put(guiCraftingProperty, result);
            if (test.get()) {
                test.set(result);
            }
        });
        return Pair.of(map, (Object)test.get());
    }

    protected void updateItem(ItemStack stack, ItemModule.ModuleInstance instance) {
        if (instance != null) {
            while (instance.parent != null) {
                instance = instance.parent;
            }
            if (!stack.m_41619_()) {
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                instance.writeToItem(stack);
            }
        }
    }

    public void linkInventory(Container inventory, int offset) {
        this.linkedInventory = inventory;
        this.inventoryOffset = offset;
    }

    public ItemStack perform() {
        ItemStack[] craftingStack = new ItemStack[]{this.craft()};
        this.forEachCraftingProperty(craftingStack[0], (craftingProperty, module, inventory, start, end, buffer) -> {
            List<ItemStack> itemStacks = craftingProperty.performCraftAction(this.old, craftingStack[0], this.player, this.blockEntity, this, this.toAdd, inventory, buffer);
            craftingStack[0] = itemStacks.remove(0);
            this.updateItem(craftingStack[0], module);
            for (int i = start; i < end; ++i) {
                this.linkedInventory.m_6836_(i, itemStacks.get(i - start));
            }
        });
        ItemModule.ModuleInstance parsingInstance = ItemModule.getModules(craftingStack[0]);
        for (int i = this.slotId.size() - 1; i >= 0; --i) {
            parsingInstance = parsingInstance.subModules.get(this.slotId.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack[0] = eventHandler.onCraft(this.old, craftingStack[0], parsingInstance);
        }
        this.linkedInventory.m_6596_();
        return craftingStack[0];
    }

    private ItemStack craft() {
        ItemStack craftingStack = this.old.m_41777_();
        if (!(this.slotId.size() == 1 || this.old.m_41782_() && (this.old.m_41782_() && this.old.m_41784_().m_128441_("modules") || this.old.m_41782_() && this.old.m_41784_().m_128441_("miapi_modules")))) {
            IllegalArgumentException exception = new IllegalArgumentException();
            Miapi.LOGGER.error("old Item has no Modules - something went very wrong", (Throwable)exception);
            Miapi.LOGGER.error(this.old.toString());
            return this.old;
        }
        ItemModule.ModuleInstance oldBaseModule = ItemModule.getModules(this.old);
        ItemModule.ModuleInstance newBaseModule = ItemModule.ModuleInstance.fromString(oldBaseModule.toString());
        Map<Object, Object> subModuleMap = new HashMap();
        if (this.slotId.isEmpty()) {
            if (this.toAdd == null) {
                return ItemStack.f_41583_;
            }
            subModuleMap = oldBaseModule.subModules;
            ItemModule.ModuleInstance newModule = new ItemModule.ModuleInstance(this.toAdd);
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ItemModule.ModuleInstance)module)) {
                    newModule.subModules.put((Integer)id, (ItemModule.ModuleInstance)module);
                }
            });
            newModule.writeToItem(craftingStack);
            ModularItemCache.clearUUIDFor(craftingStack);
            return craftingStack;
        }
        ItemModule.ModuleInstance parsingInstance = newBaseModule;
        for (int i = this.slotId.size() - 1; i > 0; --i) {
            parsingInstance = parsingInstance.subModules.get(this.slotId.get(i));
        }
        if (this.toAdd == null) {
            parsingInstance.subModules.remove(this.slotId.get(0));
        } else {
            ItemModule.ModuleInstance newModule = new ItemModule.ModuleInstance(this.toAdd);
            if (parsingInstance.subModules.get(this.slotId.get(0)) != null) {
                subModuleMap = parsingInstance.subModules.get((Object)this.slotId.get((int)0)).subModules;
            }
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ItemModule.ModuleInstance)module)) {
                    module.parent = newModule;
                    newModule.subModules.put((Integer)id, (ItemModule.ModuleInstance)module);
                }
            });
            newModule.parent = parsingInstance;
            parsingInstance.subModules.put(this.slotId.get(0), newModule);
        }
        newBaseModule.writeToItem(craftingStack);
        return craftingStack.m_41777_();
    }

    public ItemStack getPreview() {
        AtomicReference<ItemStack> craftingStack = new AtomicReference<ItemStack>(this.craft());
        this.forEachCraftingProperty(craftingStack.get(), (guiCraftingProperty, module, inventory, start, end, buffer) -> craftingStack.set(guiCraftingProperty.preview(this.old, (ItemStack)craftingStack.get(), this.player, this.blockEntity, this, this.toAdd, inventory, buffer)));
        ItemModule.ModuleInstance parsingInstance = ItemModule.getModules(craftingStack.get());
        for (int i = this.slotId.size() - 1; i >= 0; --i) {
            parsingInstance = parsingInstance.subModules.get(this.slotId.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack.set(eventHandler.onPreview(this.old, craftingStack.get(), parsingInstance));
        }
        this.linkedInventory.m_6596_();
        return craftingStack.get();
    }

    public void setData(Map<String, String> dataMap) {
        this.data = dataMap;
    }

    @Nullable
    public ItemModule.ModuleInstance getModifyingModuleInstance(ItemStack itemStack) {
        try {
            ItemModule.ModuleInstance parsingInstance = ItemModule.getModules(itemStack);
            for (int i = this.slotId.size() - 1; i >= 0; --i) {
                parsingInstance = parsingInstance.subModules.get(this.slotId.get(i));
            }
            return parsingInstance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void forEachCraftingProperty(ItemStack crafted, PropertyConsumer propertyConsumer) {
        ItemModule.ModuleInstance parsingInstance = ItemModule.getModules(crafted);
        for (int i = this.slotId.size() - 1; i >= 0; --i) {
            parsingInstance = parsingInstance.subModules.get(this.slotId.get(i));
        }
        AtomicInteger integer = new AtomicInteger(this.inventoryOffset);
        AtomicInteger counter = new AtomicInteger(0);
        ItemModule.ModuleInstance newInstance = parsingInstance;
        List<CraftingProperty> sortedProperties = RegistryInventory.moduleProperties.getFlatMap().values().stream().filter(CraftingProperty.class::isInstance).filter(property -> ((CraftingProperty)((Object)property)).shouldExecuteOnCraft(newInstance, ItemModule.getModules(crafted), crafted)).map(CraftingProperty.class::cast).sorted(Comparator.comparingDouble(CraftingProperty::getPriority)).toList();
        for (CraftingProperty craftingProperty : sortedProperties) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            int startPos = integer.get();
            int endPos = startPos + craftingProperty.getSlotPositions().size();
            for (int i = startPos; i < endPos; ++i) {
                itemStacks.add(this.linkedInventory.m_8020_(i));
            }
            propertyConsumer.accept(craftingProperty, newInstance, itemStacks, startPos, endPos, this.data);
            integer.set(endPos);
        }
    }

    protected static Player getPlayerFromUuid(UUID uuid) {
        if (Miapi.server != null) {
            return Miapi.server.m_6846_().m_11259_(uuid);
        }
        if (Minecraft.m_91087_() != null) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            return Minecraft.m_91087_().f_91073_.m_46003_(uuid);
        }
        return null;
    }

    public static interface PropertyConsumer {
        public void accept(CraftingProperty var1, ItemModule.ModuleInstance var2, List<ItemStack> var3, int var4, int var5, Map<String, String> var6);
    }

    public static interface CraftingEvent {
        public ItemStack onCraft(ItemStack var1, ItemStack var2, @Nullable ItemModule.ModuleInstance var3);

        public ItemStack onPreview(ItemStack var1, ItemStack var2, @Nullable ItemModule.ModuleInstance var3);
    }
}

